/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.handlers.ContributorHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketContributor
implements IMessage {
    public String contributor;
    public boolean wings;
    public boolean badge;
    public boolean lBadge;

    public PacketContributor() {
    }

    public PacketContributor(String contributor, boolean wings, boolean badge, boolean lBadge) {
        this.contributor = contributor;
        this.wings = wings;
        this.badge = badge;
        this.lBadge = lBadge;
    }

    public void fromBytes(ByteBuf bytes) {
        this.contributor = ByteBufUtils.readUTF8String((ByteBuf)bytes);
        this.wings = bytes.readBoolean();
        this.badge = bytes.readBoolean();
        this.lBadge = bytes.readBoolean();
    }

    public void toBytes(ByteBuf bytes) {
        ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.contributor);
        bytes.writeBoolean(this.wings);
        bytes.writeBoolean(this.badge);
        bytes.writeBoolean(this.lBadge);
    }

    public static class Handler
    implements IMessageHandler<PacketContributor, IMessage> {
        public IMessage onMessage(PacketContributor message, MessageContext ctx) {
            if (ContributorHandler.contributors.containsKey(message.contributor)) {
                ContributorHandler.Contributor contributor = ContributorHandler.contributors.get(message.contributor);
                if (ctx.side == Side.SERVER) {
                    if (!contributor.isUserValid((EntityPlayer)ctx.getServerHandler().field_147369_b)) {
                        return null;
                    }
                    contributor.contributorWingsEnabled = message.wings;
                    contributor.patreonBadgeEnabled = message.badge;
                    contributor.lolnetBadgeEnabled = message.lBadge;
                    ContributorHandler.saveContributorConfig();
                    DraconicEvolution.network.sendToAll((IMessage)message);
                } else {
                    EntityPlayer player = BrandonsCore.proxy.getClientPlayer();
                    if (!contributor.isUserValid(player) || message.contributor.equals(player.func_70005_c_())) {
                        return null;
                    }
                    contributor.contributorWingsEnabled = message.wings;
                    contributor.patreonBadgeEnabled = message.badge;
                    contributor.lolnetBadgeEnabled = message.lBadge;
                }
            }
            return null;
        }
    }
}

