/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.util.ItemNBTUtils;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IFOVModifierItem;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.DoubleConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.tool.ToolModelBakery;
import com.brandon3055.draconicevolution.handlers.BowHandler;
import com.brandon3055.draconicevolution.items.tools.ToolBase;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import com.brandon3055.draconicevolution.utils.DETextures;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WyvernBow
extends ToolBase
implements IFOVModifierItem {
    @Override
    public double getBaseAttackSpeedConfig() {
        return 0.0;
    }

    @Override
    public double getBaseAttackDamageConfig() {
        return 1.0;
    }

    @Override
    public void loadEnergyStats() {
        this.setEnergyStats(ToolStats.WYVERN_BASE_CAPACITY, 512000, 0);
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isArrow(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isArrow(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isArrow(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArrow;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            BowHandler.onPlayerStoppedUsingBow(stack, world, (EntityPlayer)entityLiving, timeLeft);
        }
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return BowHandler.onBowRightClick(player.func_184586_b(hand), world, player, hand);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entityLivingBase, int count) {
        if (entityLivingBase instanceof EntityPlayer) {
            BowHandler.onBowUsingTick(stack, (EntityPlayer)entityLivingBase, count);
        }
    }

    @Override
    public void registerRenderer(Feature feature) {
        super.registerRenderer(feature);
        ToolModelBakery.registerItemKeyGenerator((Item)this, stack -> ModelBakery.defaultItemKeyGenerator.generateKey(stack) + "|" + ItemNBTUtils.getByte((ItemStack)stack, (String)"render:bow_pull"));
    }

    @Override
    public PairKV<TextureAtlasSprite, ResourceLocation> getModels(ItemStack stack) {
        byte pull = ItemNBTUtils.getByte((ItemStack)stack, (String)"render:bow_pull");
        return new PairKV((Object)DETextures.WYVERN_BOW[pull], (Object)new ResourceLocation("draconicevolution", String.format("models/item/tools/wyvern_bow0%s.obj", pull)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayData(@Nullable ItemStack stack, World world, @Nullable BlockPos pos, List<String> displayList) {
        super.addDisplayData(stack, world, pos, displayList);
        if (BrandonsCore.proxy.getClientPlayer() != null) {
            BowHandler.BowProperties properties = new BowHandler.BowProperties(stack, BrandonsCore.proxy.getClientPlayer());
            displayList.add(InfoHelper.ITC() + I18n.func_135052_a((String)"gui.de.rfPerShot.txt", (Object[])new Object[0]) + ": " + InfoHelper.HITC() + Utils.addCommas((int)properties.calculateEnergyCost()));
            if (!properties.canFire() && properties.cantFireMessage != null) {
                displayList.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)properties.cantFireMessage, (Object[])new Object[0]));
            }
        }
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        double maxDamage = ToolStats.BOW_BASE_DAMAGE + this.getToolTier(stack) * ToolStats.BOW_TIER_MULT_DAMAGE + UpgradeHelper.getUpgradeLevel(stack, "arrowDmg") * ToolStats.BOW_MULT_DAMAGE;
        int maxSpeed = ToolStats.BOW_BASE_SPEED + this.getToolTier(stack) * ToolStats.BOW_TIER_MULT_SPEED + UpgradeHelper.getUpgradeLevel(stack, "arrowSpeed") * ToolStats.BOW_MULT_SPEED;
        registry.register(stack, new DoubleConfigField("bowArrowDamage", maxDamage, 0.0, maxDamage, "config.field.bowArrowDamage.description", IItemConfigField.EnumControlType.SLIDER));
        registry.register(stack, new IntegerConfigField("bowArrowSpeedModifier", maxSpeed, 0, maxSpeed, "config.field.bowArrowSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
        registry.register(stack, new BooleanConfigField("bowAutoFire", false, "config.field.bowAutoFire.description"));
        registry.register(stack, new DoubleConfigField("bowExplosionPower", 0.0, 0.0, 4.0, "config.field.bowExplosionPower.description", IItemConfigField.EnumControlType.SLIDER));
        registry.register(stack, new IntegerConfigField("bowZoomModifier", 0, 0, this.getMaxZoomModifier(stack), "config.field.bowZoomModifier.description", IItemConfigField.EnumControlType.SLIDER));
        return registry;
    }

    public int getMaxZoomModifier(ItemStack stack) {
        return ToolStats.BOW_WYVERN_MAX_ZOOM;
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        List<String> list = super.getValidUpgrades(stack);
        list.add("arrowDmg");
        list.add("arrowSpeed");
        list.add("drawSpeed");
        return list;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 0;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.getDisabledEnchants(stack).containsKey(enchantment)) {
            return false;
        }
        return enchantment.field_77351_y == EnumEnchantmentType.BOW || enchantment.field_77351_y == EnumEnchantmentType.ALL;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 0;
    }

    public float getNewFOV(EntityPlayer player, ItemStack stack, float currentFOV, float originalFOV, EntityEquipmentSlot slot) {
        float zoom = (float)(10 + ToolConfigHelper.getIntegerField("bowZoomModifier", stack)) / 605.0f;
        if (player.func_184607_cu() == stack) {
            if (currentFOV > 1.5f) {
                currentFOV = 1.5f;
            }
            return currentFOV - zoom;
        }
        return currentFOV;
    }
}

