/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemconfig;

import com.brandon3055.brandonscore.inventory.PlayerSlot;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IItemConfigField {
    public String getName();

    public String getUnlocalizedName();

    @SideOnly(value=Side.CLIENT)
    public String getReadableValue();

    public String getValueFraction(double var1);

    public String getDescription();

    public Object getMin();

    public Object getMax();

    public Object getValue();

    public double getFractionalValue();

    @Deprecated
    public void handleButton(EnumButton var1, int var2);

    default public void handleButton(EnumButton button, int data, EntityPlayer player, PlayerSlot itemSlot) {
        this.handleButton(button, data);
    }

    public void writeToNBT(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound var1);

    public EnumControlType getType();

    public Map<Integer, String> getValues();

    public static enum EnumButton {
        PLUS1(0),
        PLUS2(1),
        PLUS3(2),
        MAX(3),
        MINUS1(4),
        MINUS2(5),
        MINUS3(6),
        MIN(7),
        SLIDER(8),
        SELECTION(9),
        TOGGLE(10);

        public final int index;
        private static final EnumButton[] buttons;

        private EnumButton(int index) {
            this.index = index;
        }

        public static EnumButton getButton(int index) {
            if (index < 0 || index >= buttons.length) {
                FMLLog.bigWarning((String)"[DraconicEvolution - API] EnumButton#getButton Attempt to get button for invalid index! [%s]", (Object[])new Object[]{index});
                return TOGGLE;
            }
            return buttons[index];
        }

        static {
            buttons = new EnumButton[EnumButton.values().length];
            EnumButton[] enumButtonArray = EnumButton.values();
            int n = enumButtonArray.length;
            for (int i = 0; i < n; ++i) {
                EnumButton button;
                EnumButton.buttons[button.index] = button = enumButtonArray[i];
            }
        }
    }

    public static enum EnumControlType {
        PLUS1_MINUS1,
        PLUS2_MINUS2,
        PLUS3_MINUS3,
        SLIDER,
        SELECTIONS,
        TOGGLE;

    }
}

