/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.spawning;

import c4.corpsecomplex.common.Module;
import c4.corpsecomplex.common.modules.spawning.ItemScroll;
import c4.corpsecomplex.common.modules.spawning.capability.DeathLocation;
import c4.corpsecomplex.common.modules.spawning.capability.IDeathLocation;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemHandlerHelper;

public class SpawningModule
extends Module {
    @GameRegistry.ObjectHolder(value="corpsecomplex:scroll")
    public static ItemScroll scroll;
    public static boolean returnScroll;
    public static boolean registerScroll;
    public static boolean giveScroll;
    private static String[] spawnMobs;
    private static boolean disableBeds;
    private static String[] respawnItems;
    private static boolean cfgEnabled;

    public SpawningModule() {
        super("Respawning", "Customize general respawning rules");
        this.submoduleClasses = new ArrayList();
    }

    @Override
    public void loadModuleConfig() {
        this.setCategoryComment();
        cfgEnabled = this.getBool("Enable Respawning Module", false, "Set to true to enable respawning module features", true);
        spawnMobs = this.getStringList("Spawn Mobs on Death", new String[0], "Mobs to spawn at location on death", false);
        disableBeds = this.getBool("Disable Bed Spawn Points", false, "Set to true to disable beds setting spawn points", false);
        returnScroll = this.getBool("Return Scroll", false, "Set to true to enable a craftable return scroll that teleports players to their death location", true);
        giveScroll = this.getBool("Give Scroll on Respawn", false, "If Return Scroll is true, set to true to automatically give players a return scroll on respawn", false);
        respawnItems = this.getStringList("Respawn Items", new String[0], "A list of items to give players on respawn. The format is modid:item_name;stacksize;metadata.", false);
        registerScroll = cfgEnabled && returnScroll;
    }

    @Override
    public void initPropOrder() {
        this.propOrder = new ArrayList<String>(Collections.singletonList("Enable Respawning Module"));
    }

    @Override
    public void setEnabled() {
        this.enabled = cfgEnabled;
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent e) {
        if (e.getEntity() instanceof EntityPlayer) {
            IDeathLocation deathLoc;
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            if (returnScroll && (deathLoc = (IDeathLocation)player.getCapability(DeathLocation.Provider.DEATH_LOC_CAP, null)) != null) {
                deathLoc.setUsedScroll(false);
                deathLoc.setDeathLocation(player.func_180425_c());
                deathLoc.setDeathDimension(player.func_130014_f_().field_73011_w.getDimension());
                deathLoc.setHasDeathLocation(true);
            }
            if (disableBeds) {
                player.func_180473_a(null, false);
            }
            for (String s : spawnMobs) {
                Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(s), (World)player.field_70170_p);
                if (entity == null) continue;
                entity.getEntityData().func_74757_a("PersistenceRequired", true);
                if (!(entity instanceof EntityLiving)) continue;
                EntityLiving entityliving = (EntityLiving)entity;
                entity.func_70012_b(player.field_70165_t + 2.0, player.field_70163_u, player.field_70161_v + 2.0, MathHelper.func_76142_g((float)(player.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entityliving.field_70759_as = entityliving.field_70177_z;
                entityliving.field_70761_aq = entityliving.field_70177_z;
                entityliving.func_180482_a(player.field_70170_p.func_175649_E(new BlockPos((Entity)entityliving)), null);
                player.field_70170_p.func_72838_d(entity);
                entityliving.func_70642_aH();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.Clone e) {
        if (!e.isWasDeath()) {
            return;
        }
        if (returnScroll) {
            EntityPlayer player = e.getEntityPlayer();
            EntityPlayer oldPlayer = e.getOriginal();
            IDeathLocation oldDeathLoc = (IDeathLocation)oldPlayer.getCapability(DeathLocation.Provider.DEATH_LOC_CAP, null);
            IDeathLocation newDeathLoc = (IDeathLocation)player.getCapability(DeathLocation.Provider.DEATH_LOC_CAP, null);
            if (oldDeathLoc != null && newDeathLoc != null) {
                newDeathLoc.setUsedScroll(oldDeathLoc.hasUsedScroll());
                newDeathLoc.setDeathDimension(oldDeathLoc.getDeathDimension());
                newDeathLoc.setDeathLocation(oldDeathLoc.getDeathLocation());
                newDeathLoc.setHasDeathLocation(oldDeathLoc.hasDeathLocation());
            }
            if (!e.getEntityPlayer().field_70170_p.field_72995_K && giveScroll) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)e.getEntityPlayer(), (ItemStack)new ItemStack((Item)scroll));
            }
        }
        if (!e.getEntityPlayer().field_70170_p.field_72995_K && respawnItems.length > 0) {
            for (String s : respawnItems) {
                String[] parse = s.split(";");
                Item item = Item.func_111206_d((String)parse[0]);
                if (item == null) continue;
                int stacksize = parse.length > 1 ? Integer.parseInt(parse[1]) : 1;
                int metadata = parse.length > 2 ? Integer.parseInt(parse[2]) : 0;
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)e.getEntityPlayer(), (ItemStack)new ItemStack(item, stacksize, metadata));
            }
        }
    }
}

