/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.helpers;

import c4.corpsecomplex.CorpseComplex;
import c4.corpsecomplex.common.Module;
import c4.corpsecomplex.common.Submodule;
import c4.corpsecomplex.common.modules.ExperienceModule;
import c4.corpsecomplex.common.modules.HungerModule;
import c4.corpsecomplex.common.modules.effects.EffectsModule;
import c4.corpsecomplex.common.modules.inventory.InventoryModule;
import c4.corpsecomplex.common.modules.spawning.SpawningModule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public final class ModuleHelper {
    public static Configuration cfg;
    private static ArrayList<Class<? extends Module>> moduleClasses;
    private static Map<Class<? extends Module>, Module> instances;

    public static void preInit(FMLPreInitializationEvent e) {
        moduleClasses.forEach((Consumer<Class<? extends Module>>)((Consumer<Class>)module -> {
            try {
                instances.put((Class<? extends Module>)module, (Module)module.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e1) {
                CorpseComplex.logger.log(Level.ERROR, "Failed to initialize module " + module, (Throwable)e1);
            }
        }));
        ModuleHelper.forEachModule(Module::loadSubmodules);
        ModuleHelper.initConfig(e);
    }

    private static void initConfig(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        cfg = new Configuration(new File(directory.getPath(), "corpsecomplex.cfg"));
        try {
            cfg.load();
            ModuleHelper.forEachModule(module -> {
                ModuleHelper.registerEvents(module);
                module.setPropOrder();
            });
        }
        catch (Exception e1) {
            CorpseComplex.logger.log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void reloadConfigs() {
        ModuleHelper.forEachModule(ModuleHelper::registerEvents);
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private static void registerEvents(Module module) {
        module.loadModuleConfig();
        ModuleHelper.registerModuleEvents(module);
        module.forEachSubmodule(submodule -> {
            submodule.loadModuleConfig();
            ModuleHelper.registerSubmoduleEvents(submodule);
        });
    }

    private static void registerModuleEvents(Module module) {
        module.setEnabled();
        if (!module.enabled && module.prevEnabled && module.hasEvents()) {
            MinecraftForge.EVENT_BUS.unregister((Object)module);
        } else if (module.enabled && !module.prevEnabled && module.hasEvents()) {
            MinecraftForge.EVENT_BUS.register((Object)module);
        }
        module.prevEnabled = module.enabled;
    }

    private static void registerSubmoduleEvents(Submodule submodule) {
        submodule.setEnabled();
        if (!submodule.enabled && submodule.prevEnabled && submodule.hasEvents()) {
            MinecraftForge.EVENT_BUS.unregister((Object)submodule);
        } else if (submodule.enabled && !submodule.prevEnabled && submodule.hasEvents()) {
            MinecraftForge.EVENT_BUS.register((Object)submodule);
        }
        submodule.prevEnabled = submodule.enabled;
    }

    private static void addModule(Class<? extends Module> module) {
        if (!moduleClasses.contains(module)) {
            moduleClasses.add(module);
        }
    }

    private static void addModule(String modid, Class<? extends Module> module) {
        if (Loader.isModLoaded((String)modid) && !moduleClasses.contains(module)) {
            moduleClasses.add(module);
        }
    }

    private static void forEachModule(Consumer<Module> module) {
        instances.values().forEach(module);
    }

    static {
        instances = new HashMap<Class<? extends Module>, Module>();
        moduleClasses = new ArrayList();
        ModuleHelper.addModule(EffectsModule.class);
        ModuleHelper.addModule(ExperienceModule.class);
        ModuleHelper.addModule(InventoryModule.class);
        ModuleHelper.addModule(HungerModule.class);
        ModuleHelper.addModule(SpawningModule.class);
    }

    @Mod.EventBusSubscriber
    private static class ConfigChangeHandler {
        private ConfigChangeHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
            if (e.getModID().equals("corpsecomplex")) {
                ModuleHelper.reloadConfigs();
            }
        }
    }
}

