/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world.tools;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.network.MessageMachinePositions;
import org.dave.compactmachines3.schema.Schema;
import org.dave.compactmachines3.schema.SchemaRegistry;
import org.dave.compactmachines3.skyworld.SkyWorldSavedData;
import org.dave.compactmachines3.skyworld.SkyWorldType;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.DimensionBlockPos;
import org.dave.compactmachines3.world.TeleporterMachines;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;
import org.dave.compactmachines3.world.tools.StructureTools;

public class TeleportationTools {
    public static boolean tryToEnterMachine(EntityPlayer player, TileEntityMachine machine) {
        boolean playerHasHubMachine;
        BlockPos pos = machine.func_174877_v();
        World world = machine.func_145831_w();
        if (machine.isInsideItself()) {
            return false;
        }
        if (!machine.isAllowedToEnter(player)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("hint.compactmachines3.not_permitted_to_enter", new Object[0]), true);
            return false;
        }
        if (!machine.hasOwner() && world.func_175624_G() instanceof SkyWorldType && (playerHasHubMachine = SkyWorldSavedData.instance.isHubMachineOwner(player))) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("hint.compactmachines3.skyworld.only_one_machine_claim", new Object[0]), true);
            return false;
        }
        boolean isNew = machine.id == -1;
        machine.initStructure();
        WorldSavedDataMachines.getInstance().addMachinePosition(machine.id, pos, world.field_73011_w.getDimension());
        if (isNew) {
            MessageMachinePositions.updateClientMachinePositions();
        }
        TeleportationTools.teleportPlayerToMachine((EntityPlayerMP)player, machine);
        StructureTools.setBiomeForMachineId(machine.id, world.func_180494_b(pos));
        if (!machine.hasOwner() || "Unknown".equals(machine.getOwnerName())) {
            machine.setOwner(player);
            machine.func_70296_d();
            if (world.func_175624_G() instanceof SkyWorldType) {
                SkyWorldSavedData.instance.setHomeOwner(player, machine.id);
            }
        }
        return true;
    }

    public static void teleportToSkyworldHome(EntityPlayer player) {
        if (!SkyWorldSavedData.instance.hasSkyworldHome(player)) {
            return;
        }
        int id = SkyWorldSavedData.instance.getSkyworldHome(player);
        DimensionBlockPos pos = WorldSavedDataMachines.getInstance().machinePositions.get(id);
        if (pos == null) {
            return;
        }
        BlockPos spawnPoint = pos.getBlockPos();
        player.func_70634_a((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 1.2, (double)spawnPoint.func_177952_p() + 0.5);
    }

    public static int getLastKnownRoomId(EntityPlayer player, boolean getFirst) {
        NBTTagCompound playerNBT = player.getEntityData();
        if (!playerNBT.func_74764_b("compactmachines3-idHistory") && !playerNBT.func_74764_b("compactmachines3-coordHistory")) {
            return -1;
        }
        NBTTagList idHistory = playerNBT.func_150295_c("compactmachines3-idHistory", 10);
        if (idHistory.func_82582_d()) {
            idHistory = playerNBT.func_150295_c("compactmachines3-coordHistory", 10);
        }
        if (idHistory.func_82582_d()) {
            return -1;
        }
        NBTTagCompound nbt = idHistory.func_150305_b(getFirst ? 0 : idHistory.func_74745_c() - 1);
        return nbt.func_150297_b("id", 3) ? nbt.func_74762_e("id") : nbt.func_74762_e("coords");
    }

    public static void teleportPlayerToMachine(EntityPlayerMP player, int id, boolean isReturning) {
        TileEntityMachine machine;
        if (id == -1) {
            return;
        }
        NBTTagCompound playerNBT = player.getEntityData();
        if (player.field_71093_bK != ConfigurationHandler.Settings.dimensionId) {
            playerNBT.func_74768_a("compactmachines3-oldDimension", player.field_71093_bK);
            playerNBT.func_74780_a("compactmachines3-oldPosX", player.field_70165_t);
            playerNBT.func_74780_a("compactmachines3-oldPosY", player.field_70163_u);
            playerNBT.func_74780_a("compactmachines3-oldPosZ", player.field_70161_v);
            WorldServer machineWorld = DimensionTools.getServerMachineWorld();
            player.func_82242_a(0);
            PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            playerList.transferPlayerToDimension(player, ConfigurationHandler.Settings.dimensionId, (Teleporter)new TeleporterMachines(machineWorld));
            playerNBT.func_82580_o("compactmachines3-idHistory");
            playerNBT.func_82580_o("compactmachines3-coordHistory");
        }
        if (!isReturning) {
            TeleportationTools.addMachineIdToHistory(id, playerNBT);
        }
        if ((machine = WorldSavedDataMachines.getInstance().getMachine(id)) == null) {
            return;
        }
        if (machine.hasNewSchema()) {
            Schema schema = SchemaRegistry.instance.getSchema(machine.getSchemaName());
            if (schema == null) {
                CompactMachines3.logger.warn("Unknown schema used by Compact Machine @ {}", (Object)WorldSavedDataMachines.getInstance().getMachineBlockPosition(id));
            } else {
                StructureTools.restoreSchema(schema, id);
                Vec3d adjustedSpawnPosition = schema.getSpawnPosition().func_178787_e(new Vec3d((Vec3i)WorldSavedDataMachines.getInstance().getMachineRoomPosition(id)));
                WorldSavedDataMachines.getInstance().addSpawnPoint(machine.id, adjustedSpawnPosition);
                machine.setSchema(null);
                machine.func_70296_d();
            }
        }
        Vec3d destination = WorldSavedDataMachines.getInstance().spawnPoints.get(id);
        player.func_70634_a(destination.field_72450_a - 6.0, destination.field_72448_b, destination.field_72449_c);
    }

    public static void addMachineIdToHistory(int id, EntityPlayer player) {
        TeleportationTools.addMachineIdToHistory(id, player.getEntityData());
    }

    public static void addMachineIdToHistory(int id, NBTTagCompound playerNBT) {
        NBTTagList idHistory = playerNBT.func_150295_c("compactmachines3-idHistory", 10);
        if (idHistory.func_82582_d()) {
            idHistory = playerNBT.func_150295_c("compactmachines3-coordHistory", 10);
        }
        NBTTagCompound toAppend = new NBTTagCompound();
        toAppend.func_74768_a("id", id);
        idHistory.func_74742_a((NBTBase)toAppend);
        playerNBT.func_74782_a("compactmachines3-idHistory", (NBTBase)idHistory);
    }

    public static void teleportPlayerOutOfMachineDimension(EntityPlayerMP player) {
        PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        NBTTagCompound playerNBT = player.getEntityData();
        if (playerNBT.func_74764_b("compactmachines3-oldPosX")) {
            int oldDimension = playerNBT.func_74762_e("compactmachines3-oldDimension");
            double oldPosX = playerNBT.func_74769_h("compactmachines3-oldPosX");
            double oldPosY = playerNBT.func_74769_h("compactmachines3-oldPosY");
            double oldPosZ = playerNBT.func_74769_h("compactmachines3-oldPosZ");
            player.func_82242_a(0);
            playerList.transferPlayerToDimension(player, oldDimension, (Teleporter)new TeleporterMachines(DimensionTools.getWorldServerForDimension(oldDimension)));
            player.func_70634_a(oldPosX, oldPosY, oldPosZ);
        } else {
            BlockPos startPoint;
            int dimension;
            DimensionBlockPos pos;
            int firstId = TeleportationTools.getLastKnownRoomId((EntityPlayer)player, true);
            playerNBT.func_82580_o("compactmachines3-idHistory");
            playerNBT.func_82580_o("compactmachines3-coordHistory");
            if (firstId == -1) {
                firstId = StructureTools.getIdForPos(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
            }
            if ((pos = WorldSavedDataMachines.getInstance().machinePositions.get(firstId)) != null) {
                dimension = pos.getDimension();
                startPoint = pos.getBlockPos();
            } else {
                dimension = 0;
                startPoint = DimensionTools.getWorldServerForDimension((int)0).field_73011_w.getRandomizedSpawnPoint();
            }
            WorldServer world = DimensionTools.getWorldServerForDimension(dimension);
            BlockPos spawnPoint = pos != null ? TeleportationTools.getValidSpawnLocation(world, startPoint) : startPoint;
            playerList.transferPlayerToDimension(player, dimension, (Teleporter)new TeleporterMachines(world));
            player.func_70634_a((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 0.2, (double)spawnPoint.func_177952_p() + 0.5);
        }
    }

    public static BlockPos getValidSpawnLocation(WorldServer world, BlockPos start) {
        int blocksToCheck = 72;
        int radius = 1;
        int checked = 0;
        while (checked < blocksToCheck) {
            for (int y = -1; y < 2; ++y) {
                BlockPos check;
                int q;
                for (q = -radius + 1; q <= radius && checked < blocksToCheck; ++checked, ++q) {
                    check = start.func_177982_a(radius, y, q);
                    if (!world.func_175623_d(check) || !world.func_175623_d(check.func_177984_a()) || world.func_175623_d(check.func_177977_b())) continue;
                    return check;
                }
                for (q = radius - 1; q >= -radius && checked < blocksToCheck; ++checked, --q) {
                    check = start.func_177982_a(q, y, radius);
                    if (!world.func_175623_d(check) || !world.func_175623_d(check.func_177984_a()) || world.func_175623_d(check.func_177977_b())) continue;
                    return check;
                }
                for (q = radius - 1; q >= -radius && checked < blocksToCheck; ++checked, --q) {
                    check = start.func_177982_a(-radius, y, q);
                    if (!world.func_175623_d(check) || !world.func_175623_d(check.func_177984_a()) || world.func_175623_d(check.func_177977_b())) continue;
                    return check;
                }
                for (q = -radius + 1; q <= radius && checked < blocksToCheck; ++checked, ++q) {
                    check = start.func_177982_a(q, y, -radius);
                    if (!world.func_175623_d(check) || !world.func_175623_d(check.func_177984_a()) || world.func_175623_d(check.func_177977_b())) continue;
                    return check;
                }
            }
        }
        return start;
    }

    public static void teleportPlayerToMachine(EntityPlayerMP player, TileEntityMachine machine) {
        TeleportationTools.teleportPlayerToMachine(player, machine.id, false);
    }

    public static void teleportPlayerOutOfMachine(EntityPlayerMP player) {
        NBTTagCompound playerNBT = player.getEntityData();
        if (!playerNBT.func_74764_b("compactmachines3-idHistory") && !playerNBT.func_74764_b("compactmachines3-coordHistory")) {
            TeleportationTools.teleportPlayerOutOfMachineDimension(player);
            return;
        }
        NBTTagList idHistory = playerNBT.func_150295_c("compactmachines3-idHistory", 10);
        if (idHistory.func_82582_d()) {
            idHistory = playerNBT.func_150295_c("compactmachines3-coordHistory", 10);
        }
        if (idHistory.func_82582_d()) {
            TeleportationTools.teleportPlayerOutOfMachineDimension(player);
            return;
        }
        idHistory.func_74744_a(idHistory.func_74745_c() - 1);
        if (idHistory.func_74745_c() == 0) {
            TeleportationTools.teleportPlayerOutOfMachineDimension(player);
            return;
        }
        NBTTagCompound lastTag = idHistory.func_150305_b(idHistory.func_74745_c() - 1);
        int id = lastTag.func_150297_b("id", 3) ? lastTag.func_74762_e("id") : lastTag.func_74762_e("coords");
        TeleportationTools.teleportPlayerToMachine(player, id, true);
    }
}

