/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.psd.segments;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.dave.compactmachines3.gui.psd.GuiPSDScreen;
import org.dave.compactmachines3.gui.psd.Pages;
import org.dave.compactmachines3.gui.psd.segments.ChapterEntry;
import org.dave.compactmachines3.gui.psd.segments.Segment;

public class ChaptersSegment
extends Segment {
    private final Pages pages;
    private final List<ChapterEntry> chapters;

    public ChaptersSegment(Pages pages) {
        this.pages = pages;
        this.chapters = new ArrayList<ChapterEntry>();
    }

    @Override
    public void renderSegment(String name, GuiPSDScreen psd, FontRenderer fontRenderer, RenderItem renderItem, int mouseX, int mouseY) {
        for (ChapterEntry chapter : this.chapters) {
            int color = 0xDDDDDD;
            if (mouseY >= psd.offsetY + 1 && mouseY < psd.offsetY + 15) {
                color = 0x48CCCC;
            }
            RenderHelper.func_74519_b();
            renderItem.func_180450_b(chapter.getStack(), psd.offsetX, psd.offsetY);
            fontRenderer.func_78276_b(I18n.func_135052_a((String)chapter.getLangKey(), (Object[])new Object[0]), psd.offsetX + 20, psd.offsetY + 4, color);
            psd.offsetY += 16;
        }
    }

    public void addChapter(ItemStack itemStack, String targetPage) {
        this.chapters.add(new ChapterEntry(itemStack, targetPage));
    }

    @Override
    public void mouseClicked(GuiPSDScreen psd, int mouseX, int mouseY, int mouseButton) {
        int y = 0;
        for (ChapterEntry chapter : this.chapters) {
            if (mouseY >= y && mouseY < y + 15) {
                this.pages.setActivePage(chapter.getTargetPage());
                break;
            }
            y += 16;
        }
    }
}

