/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.framework.widgets;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import org.dave.compactmachines3.gui.framework.GUIHelper;
import org.dave.compactmachines3.gui.framework.event.MouseEnterEvent;
import org.dave.compactmachines3.gui.framework.event.MouseExitEvent;
import org.dave.compactmachines3.gui.framework.event.WidgetEventResult;
import org.dave.compactmachines3.gui.framework.widgets.WidgetButton;
import org.dave.compactmachines3.gui.framework.widgets.WidgetWithChoiceValue;

public class WidgetSelectButton<T>
extends WidgetWithChoiceValue<T> {
    protected static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("compactmachines3", "textures/gui/tabicons.png");
    public boolean hovered = false;
    public ResourceLocation backgroundTexture = new ResourceLocation("minecraft", "textures/blocks/concrete_silver.png");
    public TextureAtlasSprite atlasSprite;

    public WidgetSelectButton() {
        this.setHeight(20);
        this.setWidth(100);
        this.setId("WidgetSelectButton");
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            ((WidgetSelectButton)widget).hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            ((WidgetSelectButton)widget).hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addClickListener();
    }

    public WidgetSelectButton<T> setBackgroundTexture(ResourceLocation backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public WidgetSelectButton<T> setAtlasSprite(TextureAtlasSprite atlasSprite) {
        this.atlasSprite = atlasSprite;
        return this;
    }

    @Override
    public void draw(GuiScreen screen) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.atlasSprite != null) {
            screen.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            WidgetButton.fillAreaWithIcon(this.atlasSprite, 0, 0, this.width, this.height);
        } else {
            screen.field_146297_k.func_110434_K().func_110577_a(this.backgroundTexture);
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)16.0f, (float)16.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.field_146297_k.func_110434_K().func_110577_a(BUTTON_TEXTURES);
        int texOffsetX = 64;
        int texOffsetY = 84;
        int overlayWidth = 20;
        screen.func_73729_b(0, 0, texOffsetX, texOffsetY, 4, 4);
        screen.func_73729_b(this.width - 4, 0, texOffsetX + overlayWidth - 4, texOffsetY, 4, 4);
        screen.func_73729_b(0, this.height - 4, texOffsetX, texOffsetY + overlayWidth - 4, 4, 4);
        screen.func_73729_b(this.width - 4, this.height - 4, texOffsetX + overlayWidth - 4, texOffsetY + overlayWidth - 4, 4, 4);
        GUIHelper.drawStretchedTexture(4, 0, this.width - 8, 4, texOffsetX + 4, texOffsetY, 12, 4);
        GUIHelper.drawStretchedTexture(4, this.height - 4, this.width - 8, 4, texOffsetX + 4, texOffsetY + overlayWidth - 4, 12, 4);
        GUIHelper.drawStretchedTexture(0, 4, 4, this.height - 8, texOffsetX, texOffsetY + 4, 4, 12);
        GUIHelper.drawStretchedTexture(this.width - 4, 4, 4, this.height - 8, texOffsetX + overlayWidth - 4, texOffsetY + 3, 4, 12);
        FontRenderer fontrenderer = screen.field_146297_k.field_71466_p;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
        this.drawButtonContent(screen, fontrenderer);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
        if (!this.enabled) {
            GUIHelper.drawColoredRectangle(1, 1, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        } else if (this.hovered) {
            GUIHelper.drawColoredRectangle(1, 1, this.width - 2, this.height - 2, -2139057921);
        }
        GlStateManager.func_179121_F();
    }

    protected void drawButtonContent(GuiScreen screen, FontRenderer fontrenderer) {
        int color = 0xEEEEEE;
        screen.func_73732_a(fontrenderer, this.getValue().toString(), this.width / 2, (this.height - 8) / 2, color);
    }
}

