/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.framework;

import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import org.dave.compactmachines3.gui.framework.GUI;
import org.dave.compactmachines3.gui.framework.event.GuiDataUpdatedEvent;
import org.dave.compactmachines3.gui.framework.event.KeyTypedEvent;
import org.dave.compactmachines3.gui.framework.event.MouseClickEvent;
import org.dave.compactmachines3.gui.framework.event.MouseClickMoveEvent;
import org.dave.compactmachines3.gui.framework.event.MouseMoveEvent;
import org.dave.compactmachines3.gui.framework.event.MouseScrollEvent;
import org.dave.compactmachines3.gui.framework.event.UpdateScreenEvent;
import org.dave.compactmachines3.gui.framework.event.WidgetEventResult;
import org.lwjgl.input.Mouse;

public abstract class WidgetGuiContainer
extends GuiContainer {
    public boolean dataUpdated = false;
    protected GUI gui;
    private int previousMouseX = Integer.MAX_VALUE;
    private int previousMouseY = Integer.MAX_VALUE;

    public WidgetGuiContainer(Container container) {
        super(container);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.gui.fireEvent(new UpdateScreenEvent());
        this.resetMousePositions();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheelValue = Mouse.getEventDWheel();
        if (wheelValue != 0) {
            this.gui.fireEvent(new MouseScrollEvent(wheelValue));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.gui.fireEvent(new KeyTypedEvent(typedChar, keyCode)) == WidgetEventResult.CONTINUE_PROCESSING) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.gui.fireEvent(new MouseClickEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.gui.fireEvent(new MouseClickMoveEvent(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) == WidgetEventResult.CONTINUE_PROCESSING) {
            super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.dataUpdated) {
            this.dataUpdated = false;
            this.gui.fireEvent(new GuiDataUpdatedEvent());
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (mouseX != this.previousMouseX || mouseY != this.previousMouseY) {
            this.gui.fireEvent(new MouseMoveEvent(mouseX, mouseY));
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
        }
        RenderHelper.func_74520_c();
        this.gui.drawGUI((GuiScreen)this);
        this.gui.drawTooltips((GuiScreen)this, mouseX, mouseY);
        this.func_191948_b(mouseX, mouseY);
        RenderHelper.func_74518_a();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
    }

    protected void resetMousePositions() {
        this.previousMouseX = Integer.MIN_VALUE;
        this.previousMouseY = Integer.MIN_VALUE;
    }

    public void fireDataUpdateEvent() {
        this.dataUpdated = true;
    }
}

