/*
 * Decompiled with CFR 0.152.
 */
package c4.colytra.common.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import c4.colytra.util.ColytraUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.ItemHandlerHelper;

@Optional.Interface(modid="baubles", iface="baubles.api.IBauble", striprefs=true)
public class ItemElytraBauble
extends ItemElytra
implements IBauble {
    public ItemElytraBauble() {
        this.setRegistryName("elytra_bauble");
        this.func_77655_b("elytra");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        if (!world.field_72995_K) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            ItemStack stack = player.func_184586_b(hand);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                if (!baubles.getStackInSlot(i).func_190926_b() || !baubles.isItemValidForSlot(i, stack, (EntityLivingBase)player)) continue;
                baubles.setStackInSlot(i, stack.func_77946_l());
                if (!player.func_184812_l_()) {
                    stack.func_190920_e(0);
                }
                this.onEquipped(player.func_184586_b(hand), (EntityLivingBase)player);
                break;
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public BaubleType getBaubleType(ItemStack var1) {
        return BaubleType.BODY;
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_191258_p, 1.0f, 1.0f);
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        ItemStack colytra;
        if (player instanceof EntityPlayer && (colytra = ColytraUtil.wornColytra(player)) != ItemStack.field_190927_a) {
            ItemStack ret = itemstack.func_77946_l();
            itemstack.func_190918_g(1);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)player), (ItemStack)ret);
        }
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        ItemStack colytra = ColytraUtil.wornColytra(player);
        return colytra == ItemStack.field_190927_a;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

