/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline.attribute;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.AttributeKey;

public class ColourAttribute
extends VertexAttribute<int[]> {
    public static final AttributeKey<int[]> attributeKey = new AttributeKey<int[]>(){

        @Override
        public int[] newArray(int length) {
            return new int[length];
        }
    };
    private int[] colourRef;

    @Override
    public int[] newArray(int length) {
        return new int[length];
    }

    @Override
    public String getAttribName() {
        return "colourAttrib";
    }

    @Override
    public boolean load(CCRenderState state) {
        this.colourRef = state.model.getAttributes(attributeKey);
        return this.colourRef != null || !state.model.hasAttribute(attributeKey);
    }

    @Override
    public void operate(CCRenderState state) {
        state.colour = this.colourRef != null ? ColourRGBA.multiply(state.baseColour, this.colourRef[state.vertexIndex]) : state.baseColour;
    }
}

