/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui;

import codechicken.lib.gui.ClickCounter;
import codechicken.lib.gui.GuiScrollPane;
import java.awt.Rectangle;

public abstract class GuiScrollSlot
extends GuiScrollPane {
    protected String actionCommand;
    public boolean focused;
    protected ClickCounter<Integer> click = new ClickCounter();
    public boolean smoothScroll = true;

    public GuiScrollSlot(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setMargins(3, 2, 3, 2);
    }

    public GuiScrollSlot setActionCommand(String s) {
        this.actionCommand = s;
        return this;
    }

    public void setSmoothScroll(boolean b) {
        this.smoothScroll = b;
    }

    public abstract int getSlotHeight(int var1);

    protected abstract int getNumSlots();

    public void selectNext() {
    }

    public void selectPrev() {
    }

    protected abstract void slotClicked(int var1, int var2, int var3, int var4, int var5);

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, int var5, float var6);

    protected void unfocus() {
    }

    public void setFocused(boolean focus) {
        this.focused = focus;
        if (!this.focused) {
            this.unfocus();
        }
    }

    @Override
    public int contentHeight() {
        return this.getSlotY(this.getNumSlots());
    }

    public int getSlotY(int slot) {
        int h = 0;
        for (int i = 0; i < slot; ++i) {
            h += this.getSlotHeight(i);
        }
        return h;
    }

    public int getSlot(int my) {
        if (my < 0) {
            return -1;
        }
        int y = 0;
        for (int i = 0; i < this.getNumSlots(); ++i) {
            int h = this.getSlotHeight(i);
            if (my >= y && my < y + h) {
                return i;
            }
            y += h;
        }
        return -1;
    }

    public int getClickedSlot(int my) {
        return this.getSlot(my - this.windowBounds().y + this.scrolledPixels());
    }

    @Override
    public int scrolledPixels() {
        int scrolled = super.scrolledPixels();
        if (!this.smoothScroll) {
            int slot = this.getSlot(scrolled);
            int sloty = this.getSlotY(slot);
            int sloth = this.getSlotHeight(slot);
            scrolled = sloty + (int)((double)(scrolled - sloty) / (double)sloth + 0.5) * sloth;
        }
        return scrolled;
    }

    public int scrollbarAlignment() {
        return 1;
    }

    @Override
    public int scrollbarGuideAlignment() {
        return this.scrollbarAlignment();
    }

    @Override
    public Rectangle scrollbarBounds() {
        Rectangle r = super.scrollbarBounds();
        if (this.scrollbarAlignment() == -1) {
            r.x = this.x;
        }
        return r;
    }

    public void showSlot(int slot) {
        this.showSlot(this.getSlotY(slot), this.getSlotHeight(slot));
    }

    @Override
    public void slotDown(int mx, int my, int button) {
        int slot = this.getSlot(my);
        this.click.mouseDown(slot >= 0 ? Integer.valueOf(slot) : null, button);
    }

    @Override
    public void slotUp(int mx, int my, int button) {
        int slot = this.getSlot(my);
        int c = this.click.mouseUp(slot >= 0 ? Integer.valueOf(slot) : null, button);
        if (c > 0 && slot >= 0) {
            this.slotClicked(slot, button, mx, my - this.getSlotY(slot), c);
        }
    }

    @Override
    public void keyTyped(char c, int keycode) {
        if (!this.focused) {
            return;
        }
        if (keycode == 200) {
            this.selectPrev();
        }
        if (keycode == 208) {
            this.selectNext();
        }
        if (keycode == 28 && this.actionCommand != null) {
            this.sendAction(this.actionCommand, new Object[0]);
        }
    }

    @Override
    public void drawContent(int mx, int my, float frame) {
        int scrolled = this.scrolledPixels();
        Rectangle w = this.windowBounds();
        int y = 0;
        for (int slot = 0; slot < this.getNumSlots(); ++slot) {
            int h = this.getSlotHeight(slot);
            if (y + h > scrolled && y < scrolled + w.height) {
                this.drawSlot(slot, w.x, w.y + y - this.scrolledPixels(), mx, my - y, frame);
            }
            y += h;
        }
    }
}

