/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.registry;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import net.darkhax.bookshelf.lib.TableBuilder;
import net.darkhax.bookshelf.util.ModUtils;
import net.darkhax.caliper.Caliper;
import net.darkhax.caliper.FileHelper;
import net.darkhax.caliper.profiling.Profiler;
import net.darkhax.caliper.profiling.RegisterProfiler;
import net.darkhax.caliper.profiling.profilers.registry.RegistryInfo;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@RegisterProfiler(name="Registry Analysis", description="Collects info about the various registries.")
public class ProfileRegistries
extends Profiler {
    private final File registryDir = new File(Caliper.LOG_DIR, "registry");

    @Override
    public void onPreInit() {
        if (!this.registryDir.exists()) {
            this.registryDir.mkdirs();
        }
    }

    @Override
    public void onLoadComplete() {
        this.profileRegistry(ForgeRegistries.BLOCKS, "block", 4096);
        this.profileRegistry(ForgeRegistries.ITEMS, "item", 32000);
        this.profileRegistry(ForgeRegistries.POTIONS, "potion", 256);
        this.profileRegistry(ForgeRegistries.BIOMES, "biome", 256);
        this.profileRegistry(ForgeRegistries.RECIPES, "recipes", 0x3FFFFFF);
        this.profileRegistry(ForgeRegistries.ENTITIES, "entity", 0x3FFFFFF);
        this.profileRegistry(ForgeRegistries.ENCHANTMENTS, "enchantment", 32766);
        this.profileDimensions();
    }

    private void profileDimensions() {
        try (FileWriter writer = new FileWriter(new File(this.registryDir, "dimensions.md"), false);){
            TableBuilder dimTable = new TableBuilder();
            dimTable.addColumn("Name", dim -> dim.func_186065_b().replace("_", " "));
            dimTable.addColumn("Id", dim -> Integer.toString(dim.func_186068_a()));
            dimTable.addColumn("Spawn", DimensionType::shouldLoadSpawn);
            for (DimensionType dimType : DimensionType.values()) {
                dimTable.addEntry((Object)dimType);
            }
            FileHelper.writeInfoBlock(writer, 1, "Dimension Registry Analysis", "This file contains info about the various dimensions in a pack.", true);
            writer.append(FileHelper.NEW_LINE);
            writer.append(dimTable.createString());
        }
        catch (IOException e) {
            Caliper.LOG.catching((Throwable)e);
        }
    }

    private void profileRegistry(IForgeRegistry<?> registry, String name, int max) {
        int remaining = max;
        try (FileWriter writer = new FileWriter(new File(this.registryDir, name + ".md"), false);){
            TableBuilder<RegistryInfo> table = RegistryInfo.createDataTable();
            Multimap sortedRegistry = ModUtils.getSortedEntries(registry);
            for (String modId : sortedRegistry.keySet()) {
                int count = sortedRegistry.get((Object)modId).size();
                remaining -= count;
                table.addEntry((Object)new RegistryInfo(modId, count, (float)count / (float)max * 100.0f));
            }
            Collections.sort(table.getEntries(), Collections.reverseOrder());
            FileHelper.writeInfoBlock(writer, 1, name + " Registry Analysis", String.format("This file contains information about how mods are using the %s registry. %d out of %d ids available. %.3f%% of this registry is still available.", name, remaining, max, Float.valueOf((float)remaining / (float)max * 100.0f)), true);
            writer.append(FileHelper.NEW_LINE);
            writer.append(table.createString());
        }
        catch (IOException e) {
            Caliper.LOG.catching((Throwable)e);
        }
    }
}

