/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.modtype;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringJoiner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.darkhax.caliper.Caliper;
import net.darkhax.caliper.FileHelper;
import net.darkhax.caliper.profiling.Profiler;
import net.darkhax.caliper.profiling.RegisterProfiler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

@RegisterProfiler(name="Mod Types", description="Looks at what types of mods are installed.")
public class ProfileModType
extends Profiler {
    private final File file = new File(Caliper.LOG_DIR, "mod-types.md");
    private final StringJoiner mcreator = new StringJoiner(FileHelper.NEW_LINE);
    private int foundMods = 0;

    @Override
    public void onLoadComplete() {
        for (ModContainer mod : Loader.instance().getIndexedModList().values()) {
            try {
                ZipFile zfile = new ZipFile(mod.getSource());
                Throwable throwable = null;
                try {
                    Enumeration<? extends ZipEntry> zipEntries = zfile.entries();
                    boolean found = false;
                    while (zipEntries.hasMoreElements()) {
                        if (!zipEntries.nextElement().getName().startsWith("mod/mcreator/")) continue;
                        this.mcreator.add(String.format("Mod: %s File: %s", mod.getName(), mod.getSource().getName()));
                        found = true;
                        ++this.foundMods;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zfile == null) continue;
                    if (throwable != null) {
                        try {
                            zfile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    zfile.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.foundMods > 0) {
            try (FileWriter writer = new FileWriter(this.file, false);){
                FileHelper.writeInfoBlock(writer, 0, "Mod Types", "This contains a break down of mods by what type they are.", true);
                FileHelper.writeInfoBlock(writer, 1, "MCreator", "This list contains mods made with the tool MCreator.");
                writer.append(this.mcreator.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

