/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.loadtimes;

import net.darkhax.caliper.Caliper;
import net.darkhax.caliper.profiling.profilers.loadtimes.DebugLoadtimes;
import net.darkhax.caliper.profiling.profilers.loadtimes.InfoAdder;

enum InfoType {
    PRE_INIT("PreInitialization", (info, amount) -> info.preInit += amount),
    INIT("Initialization", (info, amount) -> info.init += amount),
    IMC("InterModComms$IMC", (info, amount) -> info.imc += amount),
    POST_INIT("PostInitialization", (info, amount) -> info.postInit += amount);

    private final String needle;
    private final InfoAdder op;

    private InfoType(String needle, InfoAdder op) {
        this.needle = "Bar Step: " + needle + " - ";
        this.op = op;
    }

    public boolean processMessage(String message) {
        if (message.startsWith(this.needle)) {
            try {
                String[] info = message.replace(this.needle, "").split(" took ");
                info[1] = info[1].substring(0, info[1].length() - 1);
                this.op.addInfo(DebugLoadtimes.getLoadInfo(info[0]), Double.parseDouble(info[1]));
                return true;
            }
            catch (Exception e) {
                Caliper.LOG.warn("Failed to parse line, it will be ignored. {}", new Object[0]);
                Caliper.LOG.catching((Throwable)e);
            }
        }
        return false;
    }
}

