/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.loadtimes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.TableBuilder;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.caliper.Caliper;
import net.darkhax.caliper.FileHelper;
import net.darkhax.caliper.profiling.Profiler;
import net.darkhax.caliper.profiling.RegisterProfiler;
import net.darkhax.caliper.profiling.profilers.loadtimes.LoadInfo;
import net.darkhax.caliper.profiling.profilers.loadtimes.LogListener;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;

@RegisterProfiler(name="Load Times", description="Digs through registered forge events to dump usage info.")
public class DebugLoadtimes
extends Profiler {
    private static final Map<String, LoadInfo> MODS = new HashMap<String, LoadInfo>();
    public static int signedMods = 0;

    @Override
    public void onConstructed() {
        ((Logger)FMLLog.log).addFilter((Filter)new LogListener());
    }

    @Override
    public void onLoadComplete() {
        TableBuilder<LoadInfo> table = LoadInfo.createDataTable();
        for (ModContainer mod : Loader.instance().getIndexedModList().values()) {
            DebugLoadtimes.getLoadInfo(mod.getName()).setContainerInfo(mod);
        }
        MODS.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).forEach(info -> table.addEntry(info.getValue()));
        File file = new File(Caliper.LOG_DIR, "load-times.md");
        try (FileWriter writer = new FileWriter(file, false);){
            FileHelper.writeInfoBlock(writer, 0, "Load Time Info", "This file contains an analysis of mod load times. If you are using the vanilla (or twitch) launcher, this file may show 0.0s for all the mods due to a bug in that launcher.", true);
            writer.append(FileHelper.NEW_PARAGRAPH);
            writer.append("Signed Mods: " + signedMods + " (" + MathsUtils.round((double)((double)signedMods / (double)Loader.instance().getActiveModList().size()), (int)2) * 100.0 + "%)");
            writer.append(FileHelper.NEW_PARAGRAPH);
            writer.append(table.createString());
        }
        catch (IOException e) {
            Caliper.LOG.catching((Throwable)e);
        }
    }

    protected static LoadInfo getLoadInfo(String mod) {
        LoadInfo info = MODS.getOrDefault(mod, new LoadInfo(mod));
        MODS.put(mod, info);
        return info;
    }
}

