/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling.profilers.events;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.darkhax.bookshelf.lib.TableBuilder;
import net.darkhax.caliper.Caliper;
import net.darkhax.caliper.FileHelper;
import net.darkhax.caliper.profiling.Profiler;
import net.darkhax.caliper.profiling.RegisterProfiler;
import net.darkhax.caliper.profiling.profilers.InfoPair;
import net.darkhax.caliper.profiling.profilers.events.EventInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.ASMEventHandler;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@RegisterProfiler(name="Event Analysis", description="Digs through registered forge events to dump usage info.")
public class ProfileEvents
extends Profiler {
    private final Multimap<String, EventInfo> allEvents = HashMultimap.create();

    @Override
    public void onLoadComplete() {
        this.scrapeEventBusses(MinecraftForge.EVENT_BUS, MinecraftForge.ORE_GEN_BUS, MinecraftForge.TERRAIN_GEN_BUS);
        TableBuilder<InfoPair> eventCounts = InfoPair.createDataTable("Event Name", "Listener Count");
        for (String eventName : this.allEvents.keySet()) {
            eventCounts.addEntry((Object)new InfoPair(eventName, this.allEvents.get((Object)eventName).size()));
        }
        Collections.sort(eventCounts.getEntries(), Collections.reverseOrder());
        try (FileWriter writer = new FileWriter(new File(Caliper.LOG_DIR, "events.md"), false);){
            FileHelper.writeInfoBlock(writer, 1, "Event Analysis", "This file contains an analysis on the various forge event busses. This first table lists events that have listeners, in order of most listeners. Further specifics on the listenrs.", true);
            writer.append(eventCounts.createString());
            for (String eventName : this.allEvents.keySet()) {
                writer.append(FileHelper.NEW_PARAGRAPH);
                writer.append("## " + eventName + FileHelper.NEW_LINE);
                TableBuilder<EventInfo> table = EventInfo.createTable();
                for (EventInfo info : this.allEvents.get((Object)eventName)) {
                    table.addEntry((Object)info);
                }
                writer.append(table.createString());
            }
        }
        catch (IOException e) {
            Caliper.LOG.catching((Throwable)e);
        }
    }

    private void scrapeEventBusses(EventBus ... busses) {
        for (EventBus bus : busses) {
            ConcurrentHashMap listeners = (ConcurrentHashMap)ReflectionHelper.getPrivateValue(EventBus.class, (Object)bus, (String[])new String[]{"listeners"});
            for (Map.Entry s : listeners.entrySet()) {
                for (IEventListener listener : (ArrayList)s.getValue()) {
                    if (!(listener instanceof ASMEventHandler)) continue;
                    try {
                        EventInfo info = new EventInfo((ASMEventHandler)listener);
                        if (!info.isValid()) continue;
                        this.allEvents.put((Object)info.getEvent(), (Object)info);
                    }
                    catch (Exception e) {
                        Caliper.LOG.error(listener.toString(), new Object[0]);
                        Caliper.LOG.catching((Throwable)e);
                    }
                }
            }
        }
    }
}

