/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper;

import java.io.File;
import net.darkhax.bookshelf.BookshelfRegistry;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.caliper.commands.CommandCaliper;
import net.darkhax.caliper.profiling.Profiler;
import net.darkhax.caliper.profiling.ProfilerManager;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="caliper", name="Caliper", version="1.1.44", dependencies="required-after:bookshelf@[2.2.462,)", acceptableRemoteVersions="*", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class Caliper {
    public static final LoggingHelper LOG = new LoggingHelper("Caliper");
    public static final ProfilerManager PROFILER_MANAGER = new ProfilerManager();
    public static final File LOG_DIR = new File("logs/caliper/");

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        if (!LOG_DIR.exists()) {
            LOG_DIR.mkdirs();
        }
        PROFILER_MANAGER.init(event.getASMHarvestedData());
        PROFILER_MANAGER.getFeatures().forEach(Profiler::onConstructed);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PROFILER_MANAGER.getFeatures().forEach(Profiler::onPreInit);
        BookshelfRegistry.addCommand((ICommand)new CommandCaliper());
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        PROFILER_MANAGER.getFeatures().forEach(Profiler::onPreInitClient);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PROFILER_MANAGER.getFeatures().forEach(Profiler::onInit);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROFILER_MANAGER.getFeatures().forEach(Profiler::onPostInit);
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        PROFILER_MANAGER.getFeatures().forEach(Profiler::onLoadComplete);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onClientLoadComplete(FMLLoadCompleteEvent event) {
        PROFILER_MANAGER.getFeatures().forEach(Profiler::onClientLoadComplete);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOG.warn("Invalid fingerprint detected! The file {} may have been tampered with. This version will NOT be supported by the author!", new Object[]{event.getSource().getName()});
    }
}

