/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.registry;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.gui.config.GuiIncompatibleConfig;
import com.brandon3055.brandonscore.registry.IModConfigHelper;
import com.brandon3055.brandonscore.registry.ModConfigContainer;
import com.brandon3055.brandonscore.registry.ModConfigProperty;
import com.brandon3055.brandonscore.registry.ModFeatureParser;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModConfigParser {
    private static Map<String, Configuration> modConfigurations = new HashMap<String, Configuration>();
    private static Map<String, IModConfigHelper> modConfigHelpers = new HashMap<String, IModConfigHelper>();
    private static Map<String, List<PropertyHelper>> modPropertyHelpers = new HashMap<String, List<PropertyHelper>>();
    private static Map<String, List<ConfigCategory>> modConfigCategories = new HashMap<String, List<ConfigCategory>>();
    private static boolean connectedToServer = false;
    public static Map<PropertyHelper, Object> propsRequireRestart = new HashMap<PropertyHelper, Object>();

    public static void parseASMData(ASMDataTable table) {
        String modid = "unknown";
        for (ASMDataTable.ASMData data : table.getAll(ModConfigContainer.class.getName())) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                ModConfigContainer config = clazz.getAnnotation(ModConfigContainer.class);
                modid = config.modid();
                if (IModConfigHelper.class.isAssignableFrom(clazz)) {
                    if (modConfigHelpers.containsKey(modid)) {
                        throw new RuntimeException("Mod: " + modid + " Attempted to register more than 1 IModConfigHelper class. THERE CAN ONLY BE ONE!!!");
                    }
                    modConfigHelpers.put(modid, (IModConfigHelper)clazz.newInstance());
                }
                List modProps = modPropertyHelpers.computeIfAbsent(modid, s -> new ArrayList());
                LogHelperBC.info("Found mod config container for mod: " + modid);
                for (Field field : clazz.getFields()) {
                    try {
                        if (!field.isAnnotationPresent(ModConfigProperty.class)) continue;
                        PropertyHelper container = new PropertyHelper(modid, field, field.getAnnotation(ModConfigProperty.class));
                        modProps.add(container);
                        LogHelperBC.dev("Loaded Property, " + modid + ":" + container.name);
                    }
                    catch (Throwable e) {
                        LogHelperBC.error("An error occurred while attempting to parse feature " + field.getName() + " from mod " + modid);
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable e) {
                LogHelperBC.error("An error occurred while attempting to load mod features for mod " + modid);
                Throwables.propagate((Throwable)e);
            }
        }
        DataUtils.forEachMatch(modPropertyHelpers.keySet(), mod -> !modConfigHelpers.containsKey(mod), mod -> {
            throw new RuntimeException("No IModConfigHelper was found for mod " + mod);
        });
    }

    public static void loadConfigs(FMLPreInitializationEvent event) {
        modConfigHelpers.forEach((modid, configHelper) -> modConfigurations.put((String)modid, configHelper.createConfiguration(event)));
        for (String modid2 : modPropertyHelpers.keySet()) {
            LogHelperBC.dev("Mod Config File: " + modConfigurations.get(modid2).getConfigFile());
            LogHelperBC.info("Loading mod config for: " + modid2);
            Configuration config = modConfigurations.get(modid2);
            List cats = modConfigCategories.computeIfAbsent(modid2, id -> new ArrayList());
            for (PropertyHelper helper : modPropertyHelpers.get(modid2)) {
                try {
                    if (!cats.contains(config.getCategory(helper.category))) {
                        cats.add(config.getCategory(helper.category));
                        config.setCategoryComment(helper.category, modConfigHelpers.get(modid2).getCategoryComment(helper.category));
                    }
                    helper.initialize(config);
                }
                catch (IllegalAccessException e) {
                    LogHelperBC.error("En error occurred while loading config property: " + helper.name + " for mod: " + modid2);
                    Throwables.propagate((Throwable)e);
                }
            }
            modConfigHelpers.get(modid2).onConfigLoaded();
            LogHelperBC.dev("Should save? " + config.hasChanged());
            if (!config.hasChanged()) continue;
            config.save();
        }
        modConfigurations.forEach(ModFeatureParser::loadModFeatureConfig);
    }

    public static void addFeatureProperty(String modid, Property prop, String category) {
        Configuration config = modConfigurations.get(modid);
        if (config != null && modConfigCategories.containsKey(modid) && config.hasCategory("|Mod Items/Blocks") && !modConfigCategories.get(modid).contains(config.getCategory("|Mod Items/Blocks"))) {
            modConfigCategories.get(modid).add(config.getCategory("|Mod Items/Blocks"));
        }
        modPropertyHelpers.computeIfAbsent(modid, s -> new ArrayList()).add(new PropertyHelper(modid, prop, category));
    }

    public static boolean hasConfig(String modid) {
        return modPropertyHelpers.containsKey(modid);
    }

    public static List<ConfigCategory> getModCategories(String modid) {
        return modConfigCategories.getOrDefault(modid, new ArrayList());
    }

    public static List<Property> getModProperties(String modid) {
        ArrayList<Property> list = new ArrayList<Property>();
        DataUtils.forEachMatch(modPropertyHelpers.getOrDefault(modid, new ArrayList()), prop -> prop.property != null, proop -> list.add(proop.property));
        return list;
    }

    public static void onConfigChanged(String modid) {
        ((List)modPropertyHelpers.getOrDefault(modid, new ArrayList())).forEach(prop -> {
            if (prop.property.hasChanged()) {
                prop.writeToField();
                modConfigHelpers.get(modid).onConfigChanged(prop.name, prop.category);
            }
        });
        if (modConfigurations.get(modid).hasChanged()) {
            modConfigurations.get(modid).save();
        }
    }

    public static void writeConfigForSync(MCDataOutput output) {
        output.writeBoolean(BCConfig.disableInvasiveGui);
        int propCount = 0;
        for (List<PropertyHelper> modProps : modPropertyHelpers.values()) {
            propCount += DataUtils.count(modProps, prop -> ((PropertyHelper)prop).requiresSync || ((PropertyHelper)prop).autoSync);
        }
        output.writeVarInt(propCount);
        modPropertyHelpers.forEach((s, props) -> DataUtils.forEachMatch(props, prop -> ((PropertyHelper)prop).requiresSync || ((PropertyHelper)prop).autoSync, prop -> prop.writeToBytes(output)));
    }

    @SideOnly(value=Side.CLIENT)
    public static void readConfigForSync(MCDataInput input) {
        boolean disableGui = input.readBoolean();
        int propCount = input.readVarInt();
        propsRequireRestart = new HashMap<PropertyHelper, Object>();
        for (int i = 0; i < propCount; ++i) {
            String propName;
            String propStr = input.readString();
            String propMod = propStr.substring(0, propStr.indexOf(":"));
            PropertyHelper prop = ModConfigParser.findProperty(propMod, propName = propStr.substring(propStr.indexOf(":") + 1));
            if (prop == null) continue;
            String[] propValues = new String[]{};
            String propValue = "";
            if (prop.isArray) {
                propValues = new String[input.readVarInt()];
                for (int c = 0; c < propValues.length; ++c) {
                    propValues[c] = input.readString();
                }
            } else {
                propValue = input.readString();
            }
            if (prop.autoSync) {
                prop.lockServerValue(propValue, propValues);
                continue;
            }
            if (!prop.requiresSync) continue;
            prop.serverLock = true;
            if (prop.property.getString().equals(propValue)) continue;
            propsRequireRestart.put(prop, prop.isArray ? propValues : propValue);
        }
        if (propsRequireRestart.size() > 0) {
            if (disableGui) {
                TextComponentString message = new TextComponentString(TextFormatting.RED + "[Warning] " + TextFormatting.GOLD + "Brandon's core has detected a config mismatch between your client and this server!");
                TextComponentString button = new TextComponentString(TextFormatting.BLUE + "[Click here to lean more]");
                TextComponentString buttonHover = new TextComponentString("Click here to open the config conflict gui that better explains this issue and gives you options to easily resolve this issue.");
                button.func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/bcore_client config_sync_gui")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)buttonHover)));
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)message);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)button);
            } else {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiIncompatibleConfig(propsRequireRestart));
            }
        }
        connectedToServer = true;
    }

    public static void disconnectFromServer() {
        modPropertyHelpers.forEach((s, props) -> DataUtils.forEachMatch(props, prop -> prop.serverLock, PropertyHelper::unlockServerValue));
        connectedToServer = false;
        propsRequireRestart.clear();
    }

    public static boolean isPropLocked(String modid, Property property) {
        Configuration config = modConfigurations.get(modid);
        if (config == null) {
            LogHelperBC.bigError("Attempted to access mod config but mod config does not exist! Mod: " + modid, new Object[0]);
            return false;
        }
        if (config.getCategory("|Mod Items/Blocks.Blocks").containsKey(property.getName()) || config.getCategory("|Mod Items/Blocks.Items").containsKey(property.getName())) {
            return connectedToServer;
        }
        PropertyHelper prop = ModConfigParser.findProperty(modid, property.getName());
        return prop != null && prop.serverLock;
    }

    public static void acceptServerConfig(Map<PropertyHelper, Object> incompatProps) {
        ArrayList mods = new ArrayList();
        incompatProps.forEach((prop, o) -> {
            if (prop.isArray && o instanceof String[]) {
                prop.saveServerValue("", (String[])o);
            } else if (!prop.isArray && o instanceof String) {
                prop.saveServerValue((String)o, null);
            }
            if (!mods.contains(prop.modid)) {
                mods.add(prop.modid);
            }
        });
        for (String mod : mods) {
            if (!modConfigurations.containsKey(mod)) continue;
            modConfigurations.get(mod).save();
        }
    }

    public static PropertyHelper findProperty(String modid, String propName) {
        if (modPropertyHelpers.containsKey(modid)) {
            return DataUtils.firstMatch(modPropertyHelpers.get(modid), prop -> prop.name.equals(propName));
        }
        return null;
    }

    public static Property findUnwrappedProperty(String modid, String propName, String category) {
        if (modPropertyHelpers.containsKey(modid)) {
            PropertyHelper helper = DataUtils.firstMatch(modPropertyHelpers.get(modid), prop -> prop.name.equals(propName) && prop.category.equals(category));
            return helper != null ? helper.property : null;
        }
        return null;
    }

    public static Property findUnwrappedProperty(String modid, String propName) {
        if (modPropertyHelpers.containsKey(modid)) {
            PropertyHelper helper = DataUtils.firstMatch(modPropertyHelpers.get(modid), prop -> prop.name.equals(propName));
            return helper != null ? helper.property : null;
        }
        return null;
    }

    public static void saveModConfig(String modid) {
        if (modConfigurations.containsKey(modid)) {
            modConfigurations.get(modid).save();
        }
    }

    public static class PropertyHelper {
        public final String name;
        public final String modid;
        public final String comment;
        public final String category;
        private final Field propField;
        private Object propObj;
        public boolean isArray = false;
        private Property.Type type;
        private final boolean requiresMCRestart;
        private final boolean requiresWorldRestart;
        private final boolean requiresSync;
        private final boolean autoSync;
        private int maxListLength = -1;
        private boolean isListLengthFixed = false;
        public boolean serverLock = false;
        private String clientValue = "";
        private String[] clientValues = new String[0];
        private boolean changedByServer = false;
        public Property property;

        public PropertyHelper(String modid, Property prop, String category) {
            this.modid = modid;
            this.propField = null;
            this.name = prop.getName();
            this.comment = prop.getComment();
            this.category = category;
            this.requiresMCRestart = true;
            this.requiresWorldRestart = true;
            this.requiresSync = true;
            this.autoSync = false;
            this.property = prop;
        }

        public PropertyHelper(String modid, Field propField, ModConfigProperty modProperty) {
            this.modid = modid;
            this.propField = propField;
            this.name = modProperty.name();
            this.comment = modProperty.comment();
            this.category = modProperty.category();
            this.requiresMCRestart = modProperty.requiresMCRestart();
            this.requiresWorldRestart = modProperty.requiresWorldRestart();
            this.requiresSync = modProperty.requiresSync();
            this.autoSync = modProperty.autoSync();
        }

        public void initialize(Configuration config) throws IllegalAccessException {
            this.propObj = this.propField.get(null);
            if (this.propObj instanceof Boolean) {
                this.type = Property.Type.BOOLEAN;
                this.property = config.get(this.category, this.name, ((Boolean)this.propObj).booleanValue(), this.comment);
            } else if (this.propObj instanceof boolean[]) {
                this.type = Property.Type.BOOLEAN;
                this.isArray = true;
                this.property = config.get(this.category, this.name, (boolean[])this.propObj, this.comment);
            } else if (this.propObj instanceof Double) {
                this.type = Property.Type.DOUBLE;
                this.property = config.get(this.category, this.name, ((Double)this.propObj).doubleValue(), this.comment);
            } else if (this.propObj instanceof double[]) {
                this.type = Property.Type.DOUBLE;
                this.isArray = true;
                this.property = config.get(this.category, this.name, (double[])this.propObj, this.comment);
            } else if (this.propObj instanceof Integer) {
                this.type = Property.Type.INTEGER;
                this.property = config.get(this.category, this.name, ((Integer)this.propObj).intValue(), this.comment);
            } else if (this.propObj instanceof int[]) {
                this.type = Property.Type.INTEGER;
                this.isArray = true;
                this.property = config.get(this.category, this.name, (int[])this.propObj, this.comment);
            } else if (this.propObj instanceof String) {
                this.type = Property.Type.STRING;
                this.property = config.get(this.category, this.name, (String)this.propObj, this.comment);
            } else if (this.propObj instanceof String[]) {
                this.type = Property.Type.STRING;
                this.isArray = true;
                this.property = config.get(this.category, this.name, (String[])this.propObj, this.comment);
            }
            if (this.propField.isAnnotationPresent(ModConfigProperty.ListRestrictions.class) && this.isArray) {
                ModConfigProperty.ListRestrictions lr = this.propField.getAnnotation(ModConfigProperty.ListRestrictions.class);
                this.isListLengthFixed = lr.fixedLength();
                this.maxListLength = lr.maxLength();
                this.property.setMaxListLength(this.maxListLength);
                this.property.setIsListLengthFixed(this.isListLengthFixed);
            }
            if (this.propField.isAnnotationPresent(ModConfigProperty.ValidValues.class)) {
                ModConfigProperty.ValidValues vv = this.propField.getAnnotation(ModConfigProperty.ValidValues.class);
                this.property.setValidValues(vv.values());
            }
            if (this.propField.isAnnotationPresent(ModConfigProperty.MinMax.class)) {
                ModConfigProperty.MinMax mm = this.propField.getAnnotation(ModConfigProperty.MinMax.class);
                try {
                    if (this.type == Property.Type.INTEGER) {
                        this.property.setMinValue(Integer.parseInt(mm.min()));
                        this.property.setMaxValue(Integer.parseInt(mm.max()));
                    } else if (this.type == Property.Type.DOUBLE) {
                        this.property.setMinValue(Double.parseDouble(mm.min()));
                        this.property.setMaxValue(Double.parseDouble(mm.max()));
                    }
                }
                catch (Exception e) {
                    LogHelperBC.error("An error occurred while parsing the min or max value for property: " + this.name + " config for mod: " + this.modid);
                    Throwables.propagate((Throwable)e);
                }
            }
            this.property.setRequiresMcRestart(this.requiresMCRestart);
            this.property.setRequiresWorldRestart(this.requiresWorldRestart);
            this.writeToField();
        }

        public void lockServerValue(String value, String[] values) {
            LogHelperBC.dev("Locking Property: " + this.name + " to value: " + (this.isArray ? values : value));
            this.serverLock = true;
            if (this.isArray) {
                this.clientValues = this.property.getStringList();
            } else {
                this.clientValue = this.property.getString();
            }
            if (!value.equals(this.clientValue)) {
                this.setPropValue(value, values);
                this.writeToField();
                this.property.setValue(this.clientValue);
                ReflectionHelper.setPrivateValue(Property.class, (Object)this.property, (Object)false, (String[])new String[]{"changed"});
                this.changedByServer = true;
                if (modConfigHelpers.containsKey(this.modid)) {
                    ((IModConfigHelper)modConfigHelpers.get(this.modid)).onConfigChanged(this.name, this.category);
                }
            }
        }

        public void unlockServerValue() {
            LogHelperBC.dev("Unlocking Property: " + this.name);
            this.serverLock = false;
            if (this.changedByServer) {
                this.changedByServer = false;
                this.setPropValue(this.clientValue, this.clientValues);
                this.writeToField();
                ReflectionHelper.setPrivateValue(Property.class, (Object)this.property, (Object)false, (String[])new String[]{"changed"});
                if (modConfigHelpers.containsKey(this.modid)) {
                    ((IModConfigHelper)modConfigHelpers.get(this.modid)).onConfigChanged(this.name, this.category);
                }
            }
        }

        public void saveServerValue(String value, String[] values) {
            this.serverLock = true;
            if (this.isArray) {
                this.clientValues = values;
                this.property.setValues(values);
            } else {
                this.clientValue = value;
                this.property.setValue(value);
            }
            this.writeToField();
        }

        private void setPropValue(String value, String[] values) {
            if (this.isArray) {
                this.property.setValues(values);
            } else {
                this.property.setValue(value);
            }
        }

        public void writeToField() {
            if (this.propField == null) {
                return;
            }
            try {
                switch (this.type) {
                    case STRING: {
                        if (this.isArray) {
                            this.propField.set(null, this.property.getStringList());
                            break;
                        }
                        this.propField.set(null, this.property.getString());
                        break;
                    }
                    case INTEGER: {
                        if (this.isArray) {
                            this.propField.set(null, this.property.getIntList());
                            break;
                        }
                        this.propField.set(null, this.property.getInt());
                        break;
                    }
                    case BOOLEAN: {
                        if (this.isArray) {
                            this.propField.set(null, this.property.getBooleanList());
                            break;
                        }
                        this.propField.set(null, this.property.getBoolean());
                        break;
                    }
                    case DOUBLE: {
                        if (this.isArray) {
                            this.propField.set(null, this.property.getDoubleList());
                            break;
                        }
                        this.propField.set(null, this.property.getDouble());
                    }
                }
            }
            catch (Exception e) {
                LogHelperBC.error("An error occurred while trying to set config property: " + this.name + " for mod: " + this.modid);
                e.printStackTrace();
            }
        }

        public void writeToBytes(MCDataOutput output) {
            output.writeString(this.modid + ":" + this.name);
            if (this.isArray) {
                output.writeVarInt(this.property.getStringList().length);
                for (String s : this.property.getStringList()) {
                    output.writeString(s);
                }
            } else {
                output.writeString(this.property.getString());
            }
        }
    }
}

