/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.lib.ThreadFileDownloader;
import com.brandon3055.brandonscore.network.PacketContributor;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

public class ModContributorHandler {
    public static final Map<String, ModContributorHandler> MOD_CONTRIBUTOR_HANDLERS = new HashMap<String, ModContributorHandler>();
    private final String modid;
    private final String url;
    private boolean downloadComplete = false;
    private boolean downloadFailed = false;
    private ThreadFileDownloader downloader = null;
    private File contributorFile = null;
    private File fileDirectory;
    public boolean allowOfflineMode = false;
    private Map<String, ContributorData> nameContributorDataMap = new HashMap<String, ContributorData>();
    private Map<UUID, ContributorData> uuidContributorDataMap = new HashMap<UUID, ContributorData>();
    private Map<UUID, ContributorData> validatedUserCache = new HashMap<UUID, ContributorData>();

    public ModContributorHandler(String modid, String url) {
        this.modid = modid;
        this.url = url;
        this.fileDirectory = new File(FileHandler.brandon3055Folder, "ContributorFiles");
        MOD_CONTRIBUTOR_HANDLERS.put(modid, this);
    }

    public void initialize(File fileDirectory, boolean registerEventHandler) {
        if (fileDirectory != null) {
            this.fileDirectory = fileDirectory;
        }
        if (registerEventHandler) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.contributorFile = new File(this.fileDirectory, this.modid + "-Contributors.json");
        this.startContributorDownload();
    }

    public boolean isPlayerContributor(EntityPlayer player) {
        return this.getContributorData(player) != null;
    }

    @Nullable
    public ContributorData getContributorData(EntityPlayer player) {
        if (player == null || player.func_146103_bH().getId() == null) {
            return null;
        }
        UUID id = player.func_146103_bH().getId();
        return this.validatedUserCache.computeIfAbsent(id, uuid -> {
            String username = player.func_70005_c_();
            if (this.allowOfflineMode && this.nameContributorDataMap.containsKey(username)) {
                return this.nameContributorDataMap.get(username);
            }
            if (this.uuidContributorDataMap.containsKey(id)) {
                return this.uuidContributorDataMap.get(id);
            }
            if (this.nameContributorDataMap.containsKey(username)) {
                ContributorData data = this.nameContributorDataMap.get(username);
                UUID offlineID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(Charsets.UTF_8));
                if (data.uuid == null && !offlineID.equals(uuid)) {
                    return this.nameContributorDataMap.get(username);
                }
                return null;
            }
            return null;
        });
    }

    public boolean didDownloadFail() {
        return this.downloadFailed;
    }

    public boolean isDownloadComplete() {
        return this.downloadComplete;
    }

    public void startContributorDownload() {
        if (this.downloader != null && !this.downloader.isFinished() && !this.downloader.downloadFailed()) {
            LogHelperBC.warn("The mod " + this.modid + " attempted to re-download their contributors file while the previous download was still in progress!");
            return;
        }
        this.downloadFailed = false;
        this.downloadComplete = false;
        this.downloader = new ThreadFileDownloader(this.modid + " Contributor Download Thread", this.url, this.contributorFile, (dlThread, file) -> {
            if (file == null) {
                this.downloadFailed = true;
                LogHelperBC.warn("Contributor file download for " + this.modid + " failed! The reason for the failure should be contained in the stacktrace bellow.");
                if (dlThread.getException() != null) {
                    dlThread.getException().printStackTrace();
                } else {
                    LogHelperBC.error("No error information could be found!");
                }
            } else {
                try {
                    this.readContributorFile((File)file);
                }
                catch (FileNotFoundException e) {
                    this.downloadFailed = true;
                    LogHelperBC.error("Something went wrong while attempting to read the contributor file for " + this.modid);
                    e.printStackTrace();
                }
            }
        });
        this.downloader.start();
    }

    private void readContributorFile(File file) throws FileNotFoundException {
        JsonParser parser = new JsonParser();
        JsonReader reader = new JsonReader((Reader)new FileReader(file));
        reader.setLenient(true);
        JsonObject objectList = parser.parse(reader).getAsJsonObject();
        this.nameContributorDataMap.clear();
        for (Map.Entry entry : objectList.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
            String key = (String)entry.getKey();
            UUID uuid = null;
            if (object.has("uuid")) {
                uuid = UUID.fromString(object.get("uuid").getAsString());
            }
            ContributorData data = new ContributorData(object, (String)entry.getKey(), uuid);
            this.nameContributorDataMap.put(key, data);
            if (uuid == null) continue;
            this.uuidContributorDataMap.put(uuid, data);
        }
        IOUtils.closeQuietly((Closeable)reader);
        this.downloadComplete = true;
        this.loadConfig();
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            for (ContributorData data : this.nameContributorDataMap.values()) {
                BrandonsCore.network.sendTo((IMessage)new PacketContributor(this.modid, data.name, data.config), (EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID id = event.player.func_146103_bH().getId();
        if (id != null) {
            this.validatedUserCache.remove(id);
        }
    }

    public void handleConfigChange(ContributorData contributor, NBTTagCompound config) {
        contributor.config = config;
        BrandonsCore.network.sendToAll((IMessage)new PacketContributor(this.modid, contributor.name, config));
        this.saveConfig();
    }

    @SideOnly(value=Side.CLIENT)
    public void configReceivedClient(NBTTagCompound config, String contributor) {
        if (this.nameContributorDataMap.containsKey(contributor)) {
            this.nameContributorDataMap.get(contributor).config = config;
        }
    }

    public void configReceivedServer(NBTTagCompound config, String contributor, EntityPlayerMP sender) {
        ContributorData data = this.nameContributorDataMap.get(contributor);
        ContributorData seder = this.getContributorData((EntityPlayer)sender);
        if (data != null && data == seder) {
            this.handleConfigChange(data, config);
        }
    }

    private void saveConfig() {
        try {
            File configFile = new File(this.fileDirectory, this.modid + "-ContributorConfig.json");
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(configFile));
            writer.setLenient(true);
            JsonObject jsonObject = new JsonObject();
            for (ContributorData data : this.nameContributorDataMap.values()) {
                jsonObject.addProperty(data.name, data.config.toString());
            }
            Streams.write((JsonElement)jsonObject, (JsonWriter)writer);
            IOUtils.closeQuietly((Closeable)writer);
        }
        catch (Exception e) {
            LogHelperBC.error("Something went wrong while saving the contributor config file!");
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        try {
            File configFile = new File(this.fileDirectory, this.modid + "-ContributorConfig.json");
            JsonParser parser = new JsonParser();
            JsonReader reader = new JsonReader((Reader)new FileReader(configFile));
            reader.setLenient(true);
            JsonObject objectList = parser.parse(reader).getAsJsonObject();
            for (Map.Entry entry : objectList.entrySet()) {
                String data;
                if (!((JsonElement)entry.getValue()).isJsonPrimitive() || !((JsonElement)entry.getValue()).getAsJsonPrimitive().isString() || (data = ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString()) == null) continue;
                try {
                    if (!this.nameContributorDataMap.containsKey(entry.getKey())) continue;
                    this.nameContributorDataMap.get(entry.getKey()).config = JsonToNBT.func_180713_a((String)data);
                }
                catch (NBTException nbte) {
                    LogHelperBC.error("Something went wrong while reading the config for a contributor - " + (String)entry.getKey());
                    nbte.printStackTrace();
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
        }
        catch (Exception e) {
            LogHelperBC.error("Something went wrong while loading the contributor config file!");
            e.printStackTrace();
        }
    }

    public class ContributorData {
        private JsonObject jsonObject;
        private NBTTagCompound config = new NBTTagCompound();
        public final String name;
        public final UUID uuid;

        public ContributorData(JsonObject jsonObject, String name, UUID uuid) {
            this.jsonObject = jsonObject;
            this.name = name;
            this.uuid = uuid;
        }

        public JsonObject getRawData() {
            return this.jsonObject;
        }

        public boolean hasPrimitive(String key) {
            return this.jsonObject.has(key) && this.jsonObject.get(key).isJsonPrimitive();
        }

        public JsonPrimitive getPrimitive(String key) {
            return this.jsonObject.get(key).getAsJsonPrimitive();
        }

        public boolean hasBoolean(String key) {
            return this.hasPrimitive(key) && this.getPrimitive(key).isBoolean();
        }

        public boolean hasNumber(String key) {
            return this.hasPrimitive(key) && this.getPrimitive(key).isBoolean();
        }

        public boolean hasString(String key) {
            return this.hasPrimitive(key) && this.getPrimitive(key).isBoolean();
        }

        public boolean getBoolean(String key) {
            return this.getPrimitive(key).getAsBoolean();
        }

        public int getInt(String key) {
            return this.getPrimitive(key).getAsInt();
        }

        public double getDouble(String key) {
            return this.getPrimitive(key).getAsDouble();
        }

        public String getString(String key) {
            return this.getPrimitive(key).getAsString();
        }

        public NBTTagCompound getConfigNBT() {
            return this.config;
        }

        public void saveAndSyncConfig() {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                BrandonsCore.network.sendToServer((IMessage)new PacketContributor(ModContributorHandler.this.modid, this.name, this.config));
            } else {
                ModContributorHandler.this.handleConfigChange(this, this.config);
            }
        }
    }
}

