/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public abstract class EntityFilter {
    public boolean detectPassive = true;
    public boolean detectHostile = true;
    public boolean detectPlayer = true;
    public boolean detectOther = true;
    public boolean isWhiteList = false;
    public LinkedList<String> entityList = new LinkedList();

    public boolean containsMatch(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!this.isMatch(entity)) continue;
            return true;
        }
        return false;
    }

    public List<Entity> filterEntities(List<Entity> entities) {
        ArrayList<Entity> newList = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (!this.isMatch(entity)) continue;
            newList.add(entity);
        }
        return newList;
    }

    public boolean isMatch(Entity entity) {
        if ((entity instanceof EntityAnimal || entity instanceof IAnimals && !(entity instanceof IMob)) && !this.detectPassive) {
            return false;
        }
        if (this.isTypeSelectionEnabled()) {
            if ((entity instanceof EntityMob || entity instanceof IMob) && !this.detectHostile) {
                return false;
            }
            if (entity instanceof EntityPlayer && !this.detectPlayer) {
                return false;
            }
        }
        if (!(entity instanceof EntityAnimal || entity instanceof IAnimals && !(entity instanceof IMob) || entity instanceof EntityMob || entity instanceof IMob || entity instanceof EntityPlayer || this.detectOther && this.isOtherSelectorEnabled())) {
            return false;
        }
        if (!this.isListEnabled()) {
            return true;
        }
        if (entity instanceof EntityPlayer && this.entityList.contains("[player]:" + entity.func_70005_c_())) {
            return this.isWhiteList;
        }
        if (this.entityList.contains(EntityList.func_75621_b((Entity)entity)) || entity instanceof EntityItem && this.entityList.contains("Item")) {
            return this.isWhiteList;
        }
        return !this.isWhiteList;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("detectPassive", this.detectPassive);
        compound.func_74757_a("detectHostile", this.detectHostile);
        compound.func_74757_a("detectPlayer", this.detectPlayer);
        compound.func_74757_a("detectOther", this.detectOther);
        compound.func_74757_a("isWhiteList", this.isWhiteList);
        NBTTagList list = new NBTTagList();
        for (String entity : this.entityList) {
            list.func_74742_a((NBTBase)new NBTTagString(entity));
        }
        compound.func_74782_a("entityList", (NBTBase)list);
        return compound;
    }

    public NBTTagCompound readFromNBT(NBTTagCompound compound) {
        this.detectPassive = compound.func_74767_n("detectPassive");
        this.detectHostile = compound.func_74767_n("detectHostile");
        this.detectPlayer = compound.func_74767_n("detectPlayer");
        this.detectOther = compound.func_74767_n("detectOther");
        this.isWhiteList = compound.func_74767_n("isWhiteList");
        if (compound.func_74764_b("entityList")) {
            this.entityList.clear();
            NBTTagList list = compound.func_150295_c("entityList", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.entityList.add(list.func_150307_f(i));
            }
        }
        return compound;
    }

    public void sendConfigToServer() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("detectPassive", this.detectPassive);
        compound.func_74757_a("detectHostile", this.detectHostile);
        compound.func_74757_a("detectPlayer", this.detectPlayer);
        compound.func_74757_a("detectOther", this.detectOther);
        compound.func_74757_a("isWhiteList", this.isWhiteList);
        NBTTagList list = new NBTTagList();
        for (String entity : this.entityList) {
            list.func_74742_a((NBTBase)new NBTTagString(entity));
        }
        compound.func_74782_a("entityList", (NBTBase)list);
        this.sendConfigToServer(compound);
    }

    protected abstract void sendConfigToServer(NBTTagCompound var1);

    public void receiveConfigFromClient(NBTTagCompound compound) {
        if (this.isTypeSelectionEnabled()) {
            this.detectPassive = compound.func_74767_n("detectPassive");
            this.detectHostile = compound.func_74767_n("detectHostile");
            this.detectPlayer = compound.func_74767_n("detectPlayer");
        }
        if (this.isOtherSelectorEnabled()) {
            this.detectOther = compound.func_74767_n("detectOther");
        }
        if (this.isListEnabled()) {
            this.isWhiteList = compound.func_74767_n("isWhiteList");
            if (compound.func_74764_b("entityList")) {
                this.entityList.clear();
                NBTTagList list = compound.func_150295_c("entityList", 8);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    this.entityList.add(list.func_150307_f(i));
                }
            }
        }
    }

    public abstract boolean isListEnabled();

    public abstract boolean isTypeSelectionEnabled();

    public abstract boolean isOtherSelectorEnabled();
}

