/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityElement
extends MDElementBase<EntityElement> {
    private static Map<String, Entity> renderEntityCache = new HashMap<String, Entity>();
    public int xOffset = 0;
    public int yOffset = 0;
    public double rotateSpeed = 0.0;
    public double rotation = 0.0;
    public double drawScale = 1.0;
    public boolean animate = false;
    public boolean trackMouse = false;
    public boolean drawName = false;
    public String mainHand = "";
    public String offHand = "";
    public String head = "";
    public String chest = "";
    public String legs = "";
    public String boots = "";
    private Entity renderEntity = null;
    private String entityName;
    private boolean errored = false;
    boolean animateBroken = false;
    int animTick = 0;

    public EntityElement(String entityName) {
        this.entityName = entityName;
        this.size = 64;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.setSize(this.size, this.size);
        try {
            this.renderEntity = this.getRenderEntity((World)this.mc.field_71441_e, this.entityName, EquipmentHelper.create(this));
        }
        catch (IllegalArgumentException e) {
            this.error("[Broken Entity. " + e.getMessage() + "]");
        }
        if (this.trackMouse && !(this.renderEntity instanceof EntityLivingBase)) {
            this.error("[Broken Entity. track_mouse is only supported with living entities]");
        }
        if (this.drawName && !(this.renderEntity instanceof EntityPlayer)) {
            this.error("[Broken Entity. draw_name is only supported by player's]");
        }
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.errored) {
            return;
        }
        int xPos = this.xPos() + this.xOffset;
        int yPos = this.yPos() + this.yOffset;
        try {
            int scale = (int)((double)((float)this.size / Math.max(this.renderEntity.field_70131_O, this.renderEntity.field_70130_N)) * this.drawScale);
            double posX = (double)xPos + (double)this.size / 2.0;
            double entityRotation = this.rotation + (double)((float)BCClientEventHandler.elapsedTicks + partialTicks) * this.rotateSpeed;
            this.renderEntity.field_70173_aa = BCClientEventHandler.elapsedTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(25.0 + this.getRenderZLevel() + (double)scale));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int eyeOffset = (int)((this.renderEntity.field_70131_O - this.renderEntity.func_70047_e()) * (float)scale);
            if (this.renderEntity instanceof EntityLivingBase) {
                EntityElement.drawEntityOnScreen((int)posX, yPos + this.ySize(), scale, (int)posX - mouseX, this.yPos() - mouseY + eyeOffset, (EntityLivingBase)this.renderEntity, this.trackMouse, entityRotation, this.drawName);
            } else {
                EntityElement.drawEntityOnScreen((int)posX, yPos + this.ySize(), scale, this.renderEntity, entityRotation);
            }
            GlStateManager.func_179121_F();
        }
        catch (Throwable e) {
            LogHelperBC.error("Something went wrong while attempting to render an entity on the screen!");
            LogHelperBC.error("Entity: " + this.renderEntity);
            e.printStackTrace();
            this.errored = true;
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (!this.tooltip.isEmpty() && !this.errored && this.renderEntity != null) {
            double ar = this.renderEntity.field_70131_O / this.renderEntity.field_70130_N;
            double width = (double)this.size * this.drawScale;
            double height = (double)this.size * this.drawScale;
            if (ar > 1.0) {
                width *= (double)(this.renderEntity.field_70130_N / this.renderEntity.field_70131_O);
            } else {
                height *= ar;
            }
            int x = (int)((double)(this.xPos() + this.xOffset) + ((double)this.xSize() - width) / 2.0);
            int y = (int)((double)this.yPos() + ((double)this.ySize() - height) + (double)this.yOffset);
            if (GuiHelper.isInRect(x, y, (int)width, (int)height, mouseX, mouseY)) {
                this.drawHoveringText(this.tooltip, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                return true;
            }
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, Entity ent, double rotation) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        GlStateManager.func_179114_b((float)(135.0f + (float)rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a(ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent, boolean trackMouse, double noTrackRotation, boolean drawName) {
        float rotation;
        float f = rotation = trackMouse ? 0.0f : (float)noTrackRotation;
        if (!trackMouse) {
            mouseX = 0.0f;
            mouseY = 0.0f;
        }
        if (ent instanceof EntityDragon && trackMouse) {
            mouseY += (float)(scale * 16);
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f22 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)(135.0f + rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        if (ent instanceof EntityDragon) {
            GlStateManager.func_179114_b((float)ent.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-ent.field_70759_as + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f + rotation + (float)(drawName ? 0 : 180));
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f2;
        ent.field_70177_z = f1;
        ent.field_70125_A = f22;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public Entity getRenderEntity(World world, String entityString, EquipmentHelper helper) {
        String ident = String.format("%s|mh:%s|oh:%s|h:%s|ch:%s|le:%s|bo:%s", entityString, this.mainHand, this.offHand, this.head, this.chest, this.legs, this.boots);
        if (renderEntityCache.containsKey(ident) && !this.animate) {
            return renderEntityCache.get(ident);
        }
        if (!entityString.contains(":")) {
            throw new IllegalArgumentException("Invalid entity string! Must be ether modid:entityName or player:username");
        }
        Object entity = entityString.startsWith("player:") ? EntityElement.createRenderPlayer(world, entityString.replaceFirst("player:", "")) : EntityList.func_188429_b((ResourceLocation)new ResourceLocation(entityString), (World)world);
        if (entity == null) {
            throw new IllegalArgumentException("No matching entity found for string: " + entityString);
        }
        if (entity instanceof EntityLivingBase && helper.hasEquipment) {
            helper.apply((EntityLivingBase)entity);
        } else if (helper.hasEquipment) {
            throw new IllegalArgumentException("The specified entity does not allow equipment!");
        }
        if (!this.animate) {
            renderEntityCache.put(ident, (Entity)entity);
        }
        return entity;
    }

    public static EntityPlayer createRenderPlayer(World world, String username) {
        return new EntityOtherPlayerMP(world, TileEntitySkull.func_174884_b((GameProfile)new GameProfile(null, username))){

            public String func_175154_l() {
                return super.func_175154_l();
            }

            public ResourceLocation func_110306_p() {
                ResourceLocation resourcelocation;
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(this.func_146103_bH());
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                } else {
                    UUID uuid = EntityPlayer.func_146094_a((GameProfile)this.func_146103_bH());
                    resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                }
                return resourcelocation;
            }

            public boolean func_175148_a(EnumPlayerModelParts part) {
                return true;
            }
        };
    }

    @Override
    public boolean onUpdate() {
        if (this.animate && this.renderEntity != null && !this.errored && !this.animateBroken && this.animTick != BCClientEventHandler.elapsedTicks) {
            try {
                this.renderEntity.field_70173_aa = this.animTick;
                this.animTick = BCClientEventHandler.elapsedTicks;
                this.renderEntity.func_70071_h_();
            }
            catch (Throwable e) {
                this.animateBroken = true;
            }
        }
        return super.onUpdate();
    }

    static class EquipmentHelper {
        private ItemStack mainHand = ItemStack.field_190927_a;
        private ItemStack offHand = ItemStack.field_190927_a;
        private ItemStack head = ItemStack.field_190927_a;
        private ItemStack chest = ItemStack.field_190927_a;
        private ItemStack legs = ItemStack.field_190927_a;
        private ItemStack boots = ItemStack.field_190927_a;
        public boolean hasEquipment = false;

        EquipmentHelper() {
        }

        public void apply(EntityLivingBase entity) {
            if (!this.mainHand.func_190926_b()) {
                entity.func_184611_a(EnumHand.MAIN_HAND, this.mainHand);
            }
            if (!this.offHand.func_190926_b()) {
                entity.func_184611_a(EnumHand.OFF_HAND, this.offHand);
            }
            if (!this.head.func_190926_b()) {
                entity.func_184201_a(EntityEquipmentSlot.HEAD, this.head);
            }
            if (!this.chest.func_190926_b()) {
                entity.func_184201_a(EntityEquipmentSlot.CHEST, this.chest);
            }
            if (!this.legs.func_190926_b()) {
                entity.func_184201_a(EntityEquipmentSlot.LEGS, this.legs);
            }
            if (!this.boots.func_190926_b()) {
                entity.func_184201_a(EntityEquipmentSlot.FEET, this.boots);
            }
        }

        public static EquipmentHelper create(EntityElement element) {
            StackReference stackRef;
            EquipmentHelper helper = new EquipmentHelper();
            if (!element.mainHand.isEmpty()) {
                stackRef = StackReference.fromString(element.mainHand);
                if (stackRef == null || (helper.mainHand = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.mainHand);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.offHand.isEmpty()) {
                stackRef = StackReference.fromString(element.offHand);
                if (stackRef == null || (helper.offHand = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.offHand);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.head.isEmpty()) {
                stackRef = StackReference.fromString(element.head);
                if (stackRef == null || (helper.head = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.head);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.chest.isEmpty()) {
                stackRef = StackReference.fromString(element.chest);
                if (stackRef == null || (helper.chest = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.chest);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.legs.isEmpty()) {
                stackRef = StackReference.fromString(element.legs);
                if (stackRef == null || (helper.legs = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.legs);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!element.boots.isEmpty()) {
                stackRef = StackReference.fromString(element.boots);
                if (stackRef == null || (helper.boots = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + element.boots);
                } else {
                    helper.hasEquipment = true;
                }
            }
            return helper;
        }
    }
}

