/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util;

import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockLocation {
    private final BlockPos pos;

    public BlockLocation(int x, int y, int z) {
        this(new BlockPos(x, y, z));
    }

    public BlockLocation add(int x, int y, int z) {
        return new BlockLocation(this.pos.func_177982_a(x, y, z));
    }

    public BlockLocation add(BlockLocation loc) {
        return this.add(loc.pos.func_177958_n(), loc.pos.func_177956_o(), loc.pos.func_177952_p());
    }

    public BlockLocation subtract(int x, int y, int z) {
        return this.add(-x, -y, -z);
    }

    public BlockLocation subtract(BlockLocation loc) {
        return this.subtract(loc.pos.func_177958_n(), loc.pos.func_177956_o(), loc.pos.func_177952_p());
    }

    public Block getBlock(World world) {
        return world.func_180495_p(this.pos).func_177230_c();
    }

    public IBlockState getBlockState(World world) {
        return world.func_180495_p(this.pos);
    }

    public int getMeta(World world) {
        IBlockState state = this.getBlockState(world);
        return state.func_177230_c().func_176201_c(state);
    }

    public TileEntity getTileEntity(World world) {
        return world.func_175625_s(this.pos);
    }

    public BlockLocation setBlock(World world, IBlockState block) {
        world.func_175656_a(this.pos, block);
        return this;
    }

    public BlockLocation rotate(double cos, double sin) {
        return new BlockLocation((int)Math.round((double)this.pos.func_177958_n() * cos + (double)this.pos.func_177952_p() * sin), this.pos.func_177956_o(), (int)Math.round((double)(-this.pos.func_177958_n()) * sin + (double)this.pos.func_177952_p() * cos));
    }

    public int getX() {
        return this.pos.func_177958_n();
    }

    public int getY() {
        return this.pos.func_177956_o();
    }

    public int getZ() {
        return this.pos.func_177952_p();
    }

    public BlockLocation clone() {
        return new BlockLocation(this.pos);
    }

    public static BlockLocation fromTileEntity(TileEntity te) {
        BlockPos pos = te.func_174877_v();
        return new BlockLocation(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @ConstructorProperties(value={"pos"})
    public BlockLocation(BlockPos pos) {
        this.pos = pos;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockLocation)) {
            return false;
        }
        BlockLocation other = (BlockLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        return result;
    }

    public String toString() {
        return "BlockLocation(pos=" + this.getPos() + ")";
    }
}

