/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.network;

import com.bloodnbonesgaming.lib.BNBGamingLib;
import com.bloodnbonesgaming.lib.network.BNBMessageContext;
import com.bloodnbonesgaming.lib.network.ConsumableMessage;
import com.bloodnbonesgaming.lib.network.MessageConsumer;
import com.bloodnbonesgaming.lib.network.NetworkManager;
import com.google.common.collect.Sets;
import gnu.trove.map.TObjectByteMap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.HashSet;
import net.minecraft.network.INetHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@ChannelHandler.Sharable
public class BNBSimpleChannelHandler
extends SimpleChannelInboundHandler<ConsumableMessage> {
    private final Side side;

    public BNBSimpleChannelHandler(Side side) {
        this.side = side;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ConsumableMessage message) throws Exception {
        if (message.isConsumed() || NetworkManager.INSTANCE.consumers.isEmpty()) {
            return;
        }
        TObjectByteMap<Class<? extends ConsumableMessage>> map = NetworkManager.INSTANCE.discriminators.get(this.side);
        if (!map.containsKey(message.getClass())) {
            BNBGamingLib.libInstance.getLog().warn("We received a message with no associated discriminator! Something went wrong during registration!");
            return;
        }
        BNBMessageContext context = new BNBMessageContext((INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get(), this.side);
        byte disc = map.get(message.getClass());
        HashSet returns = Sets.newHashSet();
        for (MessageConsumer consumer : NetworkManager.INSTANCE.consumers.get(this.side)) {
            returns.add(consumer.consume(message, disc, context));
            if (!message.isConsumed()) continue;
            break;
        }
        if (this.side == Side.CLIENT) {
            for (IMessage mess : returns) {
                if (mess == null) continue;
                NetworkManager.INSTANCE.sendToServer(mess);
            }
        } else {
            for (IMessage mess : returns) {
                if (mess == null) continue;
                NetworkManager.INSTANCE.sendToClient(mess, context.getServerHandler().field_147369_b);
            }
        }
    }
}

