/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.insn;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.BNBGamingClassTransformer;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class RedirectedMethodVisitor {
    private final MethodVisitor methodVisitor;

    public void visitRedirectedFieldInsn(int opcode, String owner, String name, String desc, IClassTransformerModule module) {
        BNBGamingClassTransformer transformer = BNBGamingClassTransformer.lookupOwner(module);
        String wrap = transformer.getName();
        ASMAdditionRegistry.ASMAdditionRegistryWrapper wrapper = ASMAdditionRegistry.getWrapper(wrap);
        Map<String, List<FieldNode>> fieldAdds = wrapper.getWrapperFieldAdditions();
        if (fieldAdds.containsKey(owner)) {
            List<FieldNode> fields = fieldAdds.get(owner);
            for (FieldNode fNode : fields) {
                if (!fNode.name.replaceFirst(wrap, "").equals(name)) continue;
                name = wrap + name;
                break;
            }
        }
        this.methodVisitor.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitRedirectedMethodInsn(int opcode, String owner, String name, String desc, boolean itf, IClassTransformerModule module) {
        BNBGamingClassTransformer transformer = BNBGamingClassTransformer.lookupOwner(module);
        String wrap = transformer.getName();
        ASMAdditionRegistry.ASMAdditionRegistryWrapper wrapper = ASMAdditionRegistry.getWrapper(wrap);
        Map<String, List<MethodNode>> methodAdds = wrapper.getWrapperMethodAdditions();
        if (methodAdds.containsKey(owner)) {
            List<MethodNode> methods = methodAdds.get(owner);
            for (MethodNode mNode : methods) {
                if (!mNode.name.replaceFirst(wrap, "").equals(name)) continue;
                name = wrap + name;
                break;
            }
        }
        this.methodVisitor.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @ConstructorProperties(value={"methodVisitor"})
    public RedirectedMethodVisitor(MethodVisitor methodVisitor) {
        this.methodVisitor = methodVisitor;
    }
}

