/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.structures;

import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.structures.DungeonStructure;
import WayofTime.bloodmagic.structures.DungeonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class DungeonRoom {
    public int dungeonWeight = 1;
    public Map<String, BlockPos> structureMap = new HashMap<String, BlockPos>();
    public Map<EnumFacing, List<BlockPos>> doorMap = new HashMap<EnumFacing, List<BlockPos>>();
    public List<AreaDescriptor.Rectangle> descriptorList = new ArrayList<AreaDescriptor.Rectangle>();

    public DungeonRoom(Map<String, BlockPos> structureMap, Map<EnumFacing, List<BlockPos>> doorMap, List<AreaDescriptor.Rectangle> descriptorList) {
        this.structureMap = structureMap;
        this.doorMap = doorMap;
        this.descriptorList = descriptorList;
    }

    public List<AreaDescriptor> getAreaDescriptors(PlacementSettings settings, BlockPos offset) {
        ArrayList<AreaDescriptor> newList = new ArrayList<AreaDescriptor>();
        for (AreaDescriptor areaDescriptor : this.descriptorList) {
            newList.add(areaDescriptor.rotateDescriptor(settings).offset(offset));
        }
        return newList;
    }

    public List<BlockPos> getDoorOffsetsForFacing(PlacementSettings settings, EnumFacing facing, BlockPos offset) {
        ArrayList<BlockPos> offsetList = new ArrayList<BlockPos>();
        EnumFacing originalFacing = DungeonUtil.reverseRotate(settings.func_186212_b(), settings.func_186215_c(), facing);
        if (this.doorMap.containsKey(originalFacing)) {
            List<BlockPos> doorList = this.doorMap.get(originalFacing);
            for (BlockPos doorPos : doorList) {
                offsetList.add(Template.func_186266_a((PlacementSettings)settings, (BlockPos)doorPos).func_177971_a((Vec3i)offset));
            }
        }
        return offsetList;
    }

    public boolean placeStructureAtPosition(Random rand, PlacementSettings settings, WorldServer world, BlockPos pos) {
        for (Map.Entry<String, BlockPos> entry : this.structureMap.entrySet()) {
            ResourceLocation location = new ResourceLocation(entry.getKey());
            DungeonStructure structure = new DungeonStructure(location);
            BlockPos offsetPos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)entry.getValue());
            structure.placeStructureAtPosition(rand, settings, world, pos.func_177971_a((Vec3i)offsetPos));
        }
        return true;
    }
}

