/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.core;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.altar.AltarTier;
import WayofTime.bloodmagic.api.impl.BloodMagicRecipeRegistrar;
import WayofTime.bloodmagic.block.BlockLifeEssence;
import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.registry.OrbRegistry;
import WayofTime.bloodmagic.item.ItemSlate;
import WayofTime.bloodmagic.item.soul.ItemSoulGem;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.PluginUtil;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod.EventBusSubscriber(modid="bloodmagic")
public class RegistrarBloodMagicRecipes {
    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (int i = 0; i < ItemSoulGem.names.length; ++i) {
            for (EnumDemonWillType willType : EnumDemonWillType.values()) {
                ItemStack baseGemStack = new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, i);
                ItemStack newGemStack = new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, i);
                ((ItemSoulGem)RegistrarBloodMagicItems.SOUL_GEM).setCurrentType(willType, newGemStack);
                ShapelessOreRecipe shapeless = new ShapelessOreRecipe(new ResourceLocation("bloodmagic", "soul_gem"), newGemStack, new Object[]{baseGemStack, willType.getStack()});
                event.getRegistry().register(shapeless.setRegistryName("soul_gem_" + willType.func_176610_l()));
            }
        }
        PluginUtil.handlePluginStep(PluginUtil.RegistrationStep.RECIPE_REGISTER);
        RegistrarBloodMagicItems.SOUL_TOOL_MATERIAL.setRepairItem(EnumDemonWillType.DEFAULT.getStack());
    }

    public static void registerAltarRecipes(BloodMagicRecipeRegistrar registrar) {
        registrar.addBloodAltar((Ingredient)new OreIngredient("gemDiamond"), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_WEAK), AltarTier.ONE.ordinal(), 2000, 2, 1);
        registrar.addBloodAltar((Ingredient)new OreIngredient("stone"), ItemSlate.SlateType.BLANK.getStack(), AltarTier.ONE.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193367_a((Item)Items.field_151133_ar), FluidUtil.getFilledBucket((FluidStack)new FluidStack(BlockLifeEssence.getLifeEssence(), 1000)), AltarTier.ONE.ordinal(), 1000, 5, 0);
        registrar.addBloodAltar((Ingredient)new OreIngredient("blockRedstone"), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_APPRENTICE), AltarTier.TWO.ordinal(), 5000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSlate.SlateType.BLANK.getStack()}), ItemSlate.SlateType.REINFORCED.getStack(), AltarTier.TWO.ordinal(), 2000, 5, 5);
        registrar.addBloodAltar((Ingredient)new OreIngredient("blockGold"), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_MAGICIAN), AltarTier.THREE.ordinal(), 25000, 20, 20);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSlate.SlateType.REINFORCED.getStack()}), ItemSlate.SlateType.IMBUED.getStack(), AltarTier.THREE.ordinal(), 5000, 15, 10);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSlate.SlateType.IMBUED.getStack()}), ItemSlate.SlateType.DEMONIC.getStack(), AltarTier.FOUR.ordinal(), 15000, 20, 20);
        registrar.addBloodAltar((Ingredient)new OreIngredient("blockCoal"), EnumRuneType.DUSK.getStack(), AltarTier.FOUR.ordinal(), 2000, 20, 10);
        registrar.addBloodAltar((Ingredient)new OreIngredient("obsidian"), EnumRuneType.EARTH.getStack(), AltarTier.FOUR.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar((Ingredient)new OreIngredient("blockLapis"), EnumRuneType.WATER.getStack(), AltarTier.FOUR.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193367_a((Item)Items.field_151064_bs), EnumRuneType.FIRE.getStack(), AltarTier.FOUR.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar(Ingredient.func_193367_a((Item)Items.field_151073_bk), EnumRuneType.AIR.getStack(), AltarTier.FOUR.ordinal(), 1000, 5, 5);
        registrar.addBloodAltar((Ingredient)new OreIngredient("netherStar"), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_ARCHMAGE), AltarTier.FIVE.ordinal(), 80000, 50, 100);
        registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSlate.SlateType.DEMONIC.getStack()}), ItemSlate.SlateType.ETHEREAL.getStack(), AltarTier.FIVE.ordinal(), 30000, 40, 100);
        if (ConfigHandler.general.enableTierSixEvenThoughThereIsNoContent) {
            registrar.addBloodAltar(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(RegistrarBloodMagicBlocks.DECORATIVE_BRICK, 1, 2)}), OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_TRANSCENDENT), AltarTier.SIX.ordinal(), 200000, 100, 200);
        }
    }

    public static void registerTartaricForgeRecipes(BloodMagicRecipeRegistrar registrar) {
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), 1.0, 1.0, "dustRedstone", "ingotGold", "blockGlass", "dyeBlue");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 1), 60.0, 20.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), "gemDiamond", "blockRedstone", "blockLapis");
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 2), 240.0, 50.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 1), "gemDiamond", "blockGold", ItemSlate.SlateType.IMBUED.getStack());
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 4), 4000.0, 500.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 3), Items.field_151156_bN);
        registrar.addTartaricForge(new ItemStack(RegistrarBloodMagicItems.SENTIENT_SWORD), 0.0, 0.0, new ItemStack(RegistrarBloodMagicItems.SOUL_GEM), new ItemStack(Items.field_151040_l));
    }

    public static void registerAlchemyArrayRecipes(BloodMagicRecipeRegistrar registrar) {
    }
}

