/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.waila.provider;

import WayofTime.bloodmagic.tile.TileMasterRitualStone;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DataProviderRitualController
implements IWailaDataProvider {
    public static final IWailaDataProvider INSTANCE = new DataProviderRitualController();

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("bloodmagic.ritualController")) {
            return currenttip;
        }
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("master")) {
            if (tag.func_74764_b("ritual")) {
                currenttip.add(TextHelper.localizeEffect(tag.func_74779_i("ritual"), new Object[0]));
                if (tag.func_74764_b("owner")) {
                    currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.currentOwner", tag.func_74779_i("owner")));
                }
                if (!tag.func_74767_n("active")) {
                    currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.deactivated", new Object[0]));
                }
                if (!tag.func_74767_n("enabled")) {
                    currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.config.disabled", new Object[0]));
                }
                currenttip.add("Last LP: " + tag.func_74762_e("lastLPAmount"));
            }
        } else if (tag.func_74764_b("ritual")) {
            currenttip.add(TextHelper.localizeEffect(tag.func_74779_i("ritual"), new Object[0]));
            if (!tag.func_74767_n("enabled")) {
                currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.config.disabled", new Object[0]));
            }
        }
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof TileMasterRitualStone) {
            TileMasterRitualStone mrs = (TileMasterRitualStone)te;
            tag.func_74757_a("master", true);
            if (mrs.getCurrentRitual() != null) {
                tag.func_74778_a("ritual", mrs.getCurrentRitual().getTranslationKey());
                tag.func_74757_a("active", mrs.isActive());
                if (mrs.getOwner() != null) {
                    tag.func_74778_a("owner", PlayerHelper.getUsernameFromUUID(mrs.getOwner()));
                }
                tag.func_74757_a("enabled", true);
                tag.func_74768_a("lastLPAmount", mrs.lastLPAmount);
            }
        }
        return tag;
    }
}

