/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.render.alchemyArray;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffect;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectArrowTurret;
import WayofTime.bloodmagic.alchemyArray.AlchemyCircleRenderer;
import WayofTime.bloodmagic.tile.TileAlchemyArray;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TurretAlchemyCircleRenderer
extends AlchemyCircleRenderer {
    private ResourceLocation bottomArrayResource = new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/MovementArray.png");
    private ResourceLocation middleArrayResource = new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/SkeletonTurret2.png");

    public TurretAlchemyCircleRenderer(ResourceLocation location) {
        super(location);
    }

    public TurretAlchemyCircleRenderer() {
        this(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/MovementArray.png"));
    }

    @Override
    public float getSizeModifier(float craftTime) {
        return 1.0f;
    }

    @Override
    public float getRotation(float craftTime) {
        float offset = 50.0f;
        if (craftTime >= offset) {
            float modifier = (craftTime - offset) * 5.0f;
            return modifier * 1.0f;
        }
        return 0.0f;
    }

    @Override
    public float getSecondaryRotation(float craftTime) {
        return 0.0f;
    }

    @Override
    public void renderAt(TileEntity tile, double x, double y, double z, float craftTime) {
        if (!(tile instanceof TileAlchemyArray)) {
            return;
        }
        float f = 0.0f;
        TileAlchemyArray tileArray = (TileAlchemyArray)tile;
        AlchemyArrayEffect effect = tileArray.arrayEffect;
        double pitch = 0.0;
        double yaw = 0.0;
        int arrowTimer = -1;
        if (effect instanceof AlchemyArrayEffectArrowTurret) {
            AlchemyArrayEffectArrowTurret turretEffect = (AlchemyArrayEffectArrowTurret)effect;
            pitch = (turretEffect.getPitch() - turretEffect.getLastPitch()) * (double)f + turretEffect.getLastPitch();
            yaw = (turretEffect.getYaw() - turretEffect.getLastYaw()) * (double)f + turretEffect.getLastYaw();
            arrowTimer = turretEffect.arrowTimer;
        }
        double arrowAnimation = (float)arrowTimer + f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        float rot = this.getRotation(craftTime);
        float size = 1.0f * this.getSizeModifier(craftTime);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.arrayResource);
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        EnumFacing sideHit = EnumFacing.UP;
        EnumFacing rotation = tileArray.getRotation();
        GlStateManager.func_179109_b((float)((float)sideHit.func_82601_c() * this.offsetFromFace), (float)((float)sideHit.func_96559_d() * this.offsetFromFace), (float)((float)sideHit.func_82599_e() * this.offsetFromFace));
        switch (sideHit) {
            case DOWN: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)this.getVerticalOffset(craftTime));
        GlStateManager.func_179094_E();
        double topHeightOffset = this.getTopHeightOffset(craftTime, arrowAnimation);
        double middleHeightOffset = this.getMiddleHeightOffset(craftTime, arrowAnimation);
        double bottomHeightOffset = this.getBottomHeightOffset(craftTime, arrowAnimation);
        BlockPos pos = tileArray.func_174877_v();
        World world = tileArray.func_145831_w();
        GlStateManager.func_179114_b((float)((float)(yaw + (double)(360.0f * this.getStartupPitchYawRatio(craftTime)))), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)((pitch + 90.0) * (double)this.getStartupPitchYawRatio(craftTime))), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.bottomArrayResource);
        GlStateManager.func_179114_b((float)(-rot), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-bottomHeightOffset));
        this.renderStandardCircle(tessellator, wr, size / 2.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.middleArrayResource);
        GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-middleHeightOffset));
        this.renderStandardCircle(tessellator, wr, size);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.arrayResource);
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-topHeightOffset));
        this.renderStandardCircle(tessellator, wr, size);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    public float getStartupPitchYawRatio(float craftTime) {
        if (craftTime <= 80.0f) {
            return 0.0f;
        }
        if (craftTime > 80.0f && craftTime < 140.0f) {
            return (craftTime - 80.0f) / 60.0f;
        }
        return 1.0f;
    }

    public double getBottomHeightOffset(double craftTime, double arrowAnimation) {
        if (craftTime <= 40.0) {
            return 0.0;
        }
        if (craftTime > 40.0 && craftTime < 100.0) {
            return -0.4 * (craftTime - 40.0) / 60.0;
        }
        if (craftTime >= 100.0 && craftTime < 140.0) {
            return -0.4 * (140.0 - craftTime) / 40.0;
        }
        if (arrowAnimation > 0.0 && arrowAnimation < 45.0) {
            return -0.4 * arrowAnimation / 45.0;
        }
        if (arrowAnimation >= 45.0 && arrowAnimation < 50.0) {
            return -0.4 * (50.0 - arrowAnimation) / 5.0;
        }
        return 0.0;
    }

    public double getMiddleHeightOffset(double craftTime, double arrowAnimation) {
        if (craftTime <= 40.0) {
            return 0.0;
        }
        if (craftTime > 40.0 && craftTime < 100.0) {
            return 0.1 * (craftTime - 40.0) / 60.0;
        }
        if (craftTime >= 100.0 && craftTime < 140.0) {
            return 0.1 * (140.0 - craftTime) / 40.0;
        }
        if (arrowAnimation > 0.0 && arrowAnimation < 45.0) {
            return 0.1 * arrowAnimation / 45.0;
        }
        if (arrowAnimation >= 45.0 && arrowAnimation < 50.0) {
            return 0.1 * (50.0 - arrowAnimation) / 5.0;
        }
        return 0.0;
    }

    public double getTopHeightOffset(double craftTime, double arrowAnimation) {
        if (craftTime <= 40.0) {
            return 0.0;
        }
        if (craftTime > 40.0 && craftTime < 100.0) {
            return 0.4 * (craftTime - 40.0) / 60.0;
        }
        if (craftTime >= 100.0 && craftTime < 140.0) {
            return 0.4 * (140.0 - craftTime) / 40.0;
        }
        if (arrowAnimation > 0.0 && arrowAnimation < 45.0) {
            return 0.4 * arrowAnimation / 45.0;
        }
        if (arrowAnimation >= 45.0 && arrowAnimation < 50.0) {
            return 0.4 * (50.0 - arrowAnimation) / 5.0;
        }
        return 0.0;
    }

    private void renderStandardCircle(Tessellator tessellator, BufferBuilder builder, double size) {
        double var31 = 0.0;
        double var33 = 1.0;
        double var35 = 0.0;
        double var37 = 1.0;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(size / 2.0, size / 2.0, 0.0).func_187315_a(var33, var37).func_181675_d();
        builder.func_181662_b(size / 2.0, -size / 2.0, 0.0).func_187315_a(var33, var35).func_181675_d();
        builder.func_181662_b(-size / 2.0, -size / 2.0, 0.0).func_187315_a(var31, var35).func_181675_d();
        builder.func_181662_b(-size / 2.0, size / 2.0, 0.0).func_187315_a(var31, var37).func_181675_d();
        tessellator.func_78381_a();
    }
}

