/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.hud.element;

import WayofTime.bloodmagic.client.Sprite;
import WayofTime.bloodmagic.client.hud.element.HUDElement;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ElementTileInformation<T extends TileEntity>
extends HUDElement {
    protected final Class<T> tileClass;
    private final List<Pair<Sprite, Function<T, String>>> information;

    public ElementTileInformation(int width, int lines, Class<T> tileClass) {
        super(width, 18 * lines - 2);
        this.tileClass = tileClass;
        this.information = Lists.newArrayList();
        this.gatherInformation(this.information::add);
    }

    public abstract void gatherInformation(Consumer<Pair<Sprite, Function<T, String>>> var1);

    @Override
    public void draw(ScaledResolution resolution, float partialTicks, int drawX, int drawY) {
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(Minecraft.func_71410_x().field_71476_x.func_178782_a());
        int yOffset = 0;
        for (Pair<Sprite, Function<T, String>> sprite : this.information) {
            ((Sprite)sprite.getLeft()).draw(drawX, drawY + yOffset);
            int textY = drawY + yOffset + ((Sprite)sprite.getLeft()).getTextureHeight() / 4;
            Minecraft.func_71410_x().field_71466_p.func_175063_a(tile != null && tile.getClass() == this.tileClass ? (String)((Function)sprite.getRight()).apply(tile) : "?", (float)(drawX + ((Sprite)sprite.getLeft()).getTextureWidth() + 2), (float)textY, Color.WHITE.getRGB());
            yOffset += ((Sprite)sprite.getLeft()).getTextureHeight() + 2;
        }
    }

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
        if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(trace.func_178782_a());
        return tile != null && this.tileClass.isAssignableFrom(tile.getClass());
    }
}

