/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block.base;

import WayofTime.bloodmagic.block.IBMBlock;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.item.block.base.ItemBlockEnum;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class BlockEnum<E extends Enum<E>>
extends Block
implements IBMBlock,
IVariantProvider {
    private final E[] types;
    private final PropertyEnum<E> property;
    private final BlockStateContainer realStateContainer;

    public BlockEnum(Material material, Class<E> enumClass, String propName) {
        super(material);
        this.types = (Enum[])enumClass.getEnumConstants();
        this.property = PropertyEnum.func_177709_a((String)propName, enumClass);
        this.realStateContainer = this.createStateContainer();
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    public BlockEnum(Material material, Class<E> enumClass) {
        this(material, enumClass, "type");
    }

    protected final BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).build();
    }

    public final BlockStateContainer func_176194_O() {
        return this.realStateContainer;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.property, this.types[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.property))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> subBlocks) {
        for (E type : this.types) {
            subBlocks.add((Object)new ItemStack((Block)this, 1, ((Enum)type).ordinal()));
        }
    }

    protected BlockStateContainer createStateContainer() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.property}).build();
    }

    @Override
    public ItemBlock getItem() {
        return new ItemBlockEnum(this);
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        if (this.getItem() == null) {
            return;
        }
        for (int i = 0; i < this.types.length; ++i) {
            variants.put(i, (Object)(this.getProperty().func_177701_a() + "=" + ((Enum)this.types[i]).name()));
        }
    }

    public E[] getTypes() {
        return this.types;
    }

    public PropertyEnum<E> getProperty() {
        return this.property;
    }

    public BlockStateContainer getRealStateContainer() {
        return this.realStateContainer;
    }
}

