/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.alchemyArray;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffect;
import WayofTime.bloodmagic.event.TeleposeEvent;
import WayofTime.bloodmagic.tile.TileAlchemyArray;
import WayofTime.bloodmagic.util.Utils;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class AlchemyArrayEffectLaputa
extends AlchemyArrayEffect {
    public static final int TELEPOSE_DELAY = 4;
    private BlockPos currentPos = BlockPos.field_177992_a;
    private int radius = -1;
    private int teleportHeightOffset = 5;

    public AlchemyArrayEffectLaputa(String key) {
        super(key);
    }

    @Override
    public boolean update(TileEntity tile, int ticksActive) {
        if (ticksActive >= 100) {
            World world = tile.func_145831_w();
            if (this.radius == -1) {
                ((TileAlchemyArray)tile).setItemDrop(false);
                this.radius = this.getRandomRadius(world.field_73012_v);
                this.teleportHeightOffset = this.getRandomHeightOffset(world.field_73012_v);
                this.currentPos = new BlockPos(-this.radius, -this.radius, -this.radius);
            }
            BlockPos pos = tile.func_174877_v();
            if (world.field_72995_K) {
                return false;
            }
            int j = -this.radius;
            int i = -this.radius;
            int k = -this.radius;
            if (this.currentPos != null) {
                j = this.currentPos.func_177956_o();
                i = this.currentPos.func_177958_n();
                k = this.currentPos.func_177952_p();
            }
            int checks = 0;
            int maxChecks = 100;
            if (j <= this.radius) {
                while (i <= this.radius) {
                    while (k <= this.radius) {
                        if (i == 0 && j == 0 && k == 0) {
                            ++k;
                            continue;
                        }
                        if (++checks >= maxChecks) {
                            this.currentPos = new BlockPos(i, j, k);
                            return false;
                        }
                        if (this.checkIfSphere(this.radius, i, j, k)) {
                            BlockPos newPos = pos.func_177982_a(i, j, k);
                            BlockPos offsetPos = newPos.func_177981_b(this.teleportHeightOffset);
                            IBlockState state = world.func_180495_p(newPos);
                            TeleposeEvent event = new TeleposeEvent(world, newPos, world, offsetPos);
                            if (state.func_185887_b(world, newPos) > 0.0f && !MinecraftForge.EVENT_BUS.post((Event)event) && Utils.swapLocations(event.initalWorld, event.initialBlockPos, event.finalWorld, event.finalBlockPos)) {
                                this.currentPos = new BlockPos(i, j, ++k);
                                return false;
                            }
                        }
                        ++k;
                    }
                    ++i;
                    k = -this.radius;
                }
                i = -this.radius;
                this.currentPos = new BlockPos(i, ++j, k);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean checkIfSphere(float radius, float xOff, float yOff, float zOff) {
        float possOffset = 0.5f;
        return xOff * xOff + yOff * yOff + zOff * zOff <= (radius + possOffset) * (radius + possOffset);
    }

    public int getRandomRadius(Random rand) {
        return rand.nextInt(5) + 4;
    }

    public int getRandomHeightOffset(Random rand) {
        return this.radius * 2 + 1 + rand.nextInt(5);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("radius", this.radius);
        tag.func_74768_a("teleportHeightOffset", this.teleportHeightOffset);
        tag.func_74768_a("xCoord", this.currentPos.func_177958_n());
        tag.func_74768_a("yCoord", this.currentPos.func_177956_o());
        tag.func_74768_a("zCoord", this.currentPos.func_177952_p());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.radius = tag.func_74762_e("radius");
        this.teleportHeightOffset = tag.func_74762_e("teleportHeightOffset");
        this.currentPos = new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
    }

    @Override
    public AlchemyArrayEffect getNewCopy() {
        return new AlchemyArrayEffectLaputa(this.key);
    }
}

