/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.alchemyArray;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffect;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectCrafting;
import WayofTime.bloodmagic.client.render.alchemyArray.BindingAlchemyCircleRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AlchemyArrayEffectBinding
extends AlchemyArrayEffectCrafting {
    public AlchemyArrayEffectBinding(String key, ItemStack outputStack) {
        super(key, outputStack, 200);
    }

    @Override
    public boolean update(TileEntity tile, int ticksActive) {
        if (ticksActive >= 50 && ticksActive <= 250) {
            this.spawnLightningOnCircle(tile.func_145831_w(), tile.func_174877_v(), ticksActive);
        }
        if (tile.func_145831_w().field_72995_K) {
            return false;
        }
        if (ticksActive >= 300) {
            BlockPos pos = tile.func_174877_v();
            ItemStack output = this.outputStack.func_77946_l();
            EntityItem outputEntity = new EntityItem(tile.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, output);
            tile.func_145831_w().func_72838_d((Entity)outputEntity);
            return true;
        }
        return false;
    }

    public void spawnLightningOnCircle(World world, BlockPos pos, int ticksActive) {
        if (ticksActive % 50 == 0) {
            int circle = ticksActive / 50 - 1;
            float distance = BindingAlchemyCircleRenderer.getDistanceOfCircle(circle, ticksActive);
            float angle = BindingAlchemyCircleRenderer.getAngleOfCircle(circle, ticksActive);
            double dispX = (double)distance * Math.sin(angle);
            double dispZ = (double)(-distance) * Math.cos(angle);
            EntityLightningBolt lightning = new EntityLightningBolt(world, (double)pos.func_177958_n() + dispX, (double)pos.func_177956_o(), (double)pos.func_177952_p() + dispZ, true);
            world.func_72838_d((Entity)lightning);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public AlchemyArrayEffect getNewCopy() {
        return new AlchemyArrayEffectBinding(this.key, this.outputStack);
    }
}

