/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.gen.feature;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import me.superckl.api.biometweaker.world.gen.feature.WorldGeneratorBuilder;
import me.superckl.api.superscript.util.BlockEquivalencePredicate;
import me.superckl.biometweaker.common.world.gen.feature.WorldGenMineableWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenMineableBuilder
extends WorldGeneratorBuilder<WorldGenMineableWrapper<WorldGenMinable>> {
    private int size = 9;
    private int maxHeight = 128;
    private int minHeight = 0;
    private Predicate<IBlockState> replacePredicate = new BlockEquivalencePredicate(Blocks.field_150348_b.func_176223_P());

    @Override
    public WorldGenMineableWrapper<WorldGenMinable> build() {
        WorldGenMinable gen = new WorldGenMinable(this.mainBlock, this.size, this.replacePredicate);
        if (this.maxHeight < this.minHeight) {
            int i = this.minHeight;
            this.minHeight = this.maxHeight;
            this.maxHeight = i;
        } else if (this.maxHeight == this.minHeight) {
            if (this.minHeight < 255) {
                ++this.maxHeight;
            } else {
                --this.minHeight;
            }
        }
        return new WorldGenMineableWrapper<WorldGenMinable>(gen, this.count, this.maxHeight, this.minHeight);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Predicate<IBlockState> getReplacePredicate() {
        return this.replacePredicate;
    }

    public void addReplacePredicate(Predicate<IBlockState> predicate) {
        this.replacePredicate = Predicates.or(predicate, this.replacePredicate);
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }
}

