/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.superckl.biometweaker.BiomeTweaker;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ReloadScriptsConfigEntry
extends GuiConfigEntries.ButtonEntry {
    private boolean youSure;
    private int pressedCounter;

    public ReloadScriptsConfigEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
        super(owningScreen, owningEntryList, configElement);
        this.btnValue.field_146126_j = "Reload Scripts";
    }

    public void updateValueButtonText() {
        this.btnValue.field_146126_j = this.youSure ? "Are you sure?" : "Reload Scripts";
    }

    public void drawToolTip(int mouseX, int mouseY) {
        if (this.pressedCounter-- > 0) {
            this.owningScreen.drawToolTip((List)ImmutableList.of((Object)(TextFormatting.AQUA + "Scripts reloaded."), (Object)(TextFormatting.RED + "Don't spam the button!")), mouseX, mouseY);
        } else {
            super.drawToolTip(mouseX, mouseY);
        }
    }

    public void valueButtonPressed(int slotIndex) {
        if (this.pressedCounter > 0) {
            return;
        }
        if (this.youSure) {
            try {
                BiomeTweaker.getInstance().getConfig().loadValues();
                BiomeTweaker.getInstance().getCommandManager().reset();
                BiomeTweaker.getInstance().parseScripts();
                this.pressedCounter = 200;
            }
            catch (Exception e) {
                LogHelper.error("Failed to reload scripts!");
                e.printStackTrace();
            }
        }
        this.youSure = !this.youSure;
    }

    public boolean isDefault() {
        return !this.youSure;
    }

    public void setToDefault() {
        this.youSure = false;
        this.btnValue.field_146126_j = "Reload Scripts";
    }

    public boolean isChanged() {
        return this.youSure;
    }

    public void undoChanges() {
        this.youSure = false;
        this.btnValue.field_146126_j = "Reload Scripts";
    }

    public boolean saveConfigElement() {
        return false;
    }

    public Object getCurrentValue() {
        return null;
    }

    public Object[] getCurrentValues() {
        return null;
    }
}

