/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.biometweaker.property;

import com.google.gson.JsonPrimitive;
import me.superckl.api.biometweaker.block.BlockStateBuilder;
import me.superckl.api.biometweaker.property.Property;
import me.superckl.api.biometweaker.script.wrapper.BTParameterTypes;
import me.superckl.api.superscript.script.ParameterType;
import me.superckl.api.superscript.script.ParameterTypes;
import me.superckl.api.superscript.script.ScriptHandler;
import me.superckl.api.superscript.util.WarningHelper;
import net.minecraft.block.state.IBlockState;

public class PropertyHelper {
    public static void setProperty(Object obj, Property<?> property, JsonPrimitive value, ScriptHandler handler) throws Exception {
        if (!property.isSettable()) {
            throw new UnsupportedOperationException("Property is not settable!");
        }
        if (!property.getTargetClass().isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Property is not applicable to object with type " + obj.getClass().getSimpleName());
        }
        Class<IBlockState> type = property.getTypeClass();
        if (type.isAssignableFrom(IBlockState.class)) {
            ((Property)WarningHelper.uncheckedCast(property)).set(obj, ((BlockStateBuilder)BTParameterTypes.BLOCKSTATE_BUILDER.tryParse(value.getAsString(), handler)).build());
            return;
        }
        ParameterType<?> pType = ParameterTypes.getDefaultType(type);
        if (pType != null) {
            PropertyHelper.typeSafeSet(property, obj, pType.tryParse(value.getAsString(), handler));
        }
    }

    public static <K> void typeSafeSet(Property<K> prop, Object obj, Object val) {
        prop.set(obj, WarningHelper.uncheckedCast(val));
    }
}

