/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.biometweaker.property;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import me.superckl.api.biometweaker.property.Property;
import me.superckl.api.superscript.util.WarningHelper;

public final class PropertyField<K>
extends Property<K> {
    private final Class<?> clazz;
    private final String fieldName;
    private Field field;

    public PropertyField(Class<?> clazz, String fieldName, Class<K> typeClass) {
        super(typeClass);
        this.clazz = clazz;
        this.fieldName = fieldName;
    }

    @Override
    public void set(Object obj, K val) throws IllegalStateException, IllegalArgumentException {
        this.verifyField();
        try {
            this.field.set(obj, val);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to set field " + this.fieldName + " in class " + this.clazz.getCanonicalName() + " to value " + val.toString(), e);
        }
    }

    @Override
    public K get(Object obj) throws IllegalStateException, IllegalArgumentException {
        this.verifyField();
        try {
            return (K)WarningHelper.uncheckedCast(this.field.get(obj));
        }
        catch (IllegalArgumentException e1) {
            throw new IllegalArgumentException("Unable to get field " + this.fieldName + " in class " + this.clazz.getCanonicalName(), e1);
        }
        catch (Exception e2) {
            throw new IllegalStateException("Unable to get field " + this.fieldName + " in class " + this.clazz.getCanonicalName(), e2);
        }
    }

    public void verifyField() throws IllegalStateException, IllegalArgumentException {
        if (this.field == null && this.clazz != null && this.fieldName != null && !this.fieldName.isEmpty()) {
            try {
                this.field = this.clazz.getDeclaredField(this.fieldName);
                if (!this.field.getType().isAssignableFrom(this.field.getType().isPrimitive() ? Primitives.unwrap(this.getTypeClass()) : this.getTypeClass())) {
                    throw new IllegalStateException("Generic Type of Property is not assignable to Field Type.");
                }
                if (!this.getTypeClass().isAssignableFrom(this.field.getType().isPrimitive() ? Primitives.wrap(this.field.getType()) : this.field.getType())) {
                    throw new IllegalStateException("Field Type is not assignable to Generic Type of Property.");
                }
                this.field.setAccessible(true);
            }
            catch (IllegalArgumentException e1) {
                throw new IllegalArgumentException("Unable to find field " + this.fieldName + " in class " + this.clazz.getCanonicalName(), e1);
            }
            catch (Exception e2) {
                throw new IllegalStateException("Unable to find field " + this.fieldName + " in class " + this.clazz.getCanonicalName(), e2);
            }
        }
    }

    @Override
    public Class<?> getTargetClass() {
        return this.clazz;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isSettable() {
        return true;
    }
}

