/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.util.biome.BiomeUtils;
import biomesoplenty.common.world.BOPMapGenScatteredFeature;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.NoiseGeneratorBOPByte;
import biomesoplenty.common.world.TerrainSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.WoodlandMansion;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorOverworldBOP
implements IChunkGenerator {
    private Random rand;
    private NoiseGeneratorOctaves xyzNoiseGenA;
    private NoiseGeneratorOctaves xyzNoiseGenB;
    private NoiseGeneratorOctaves xyzBalanceNoiseGen;
    private NoiseGeneratorPerlin stoneNoiseGen;
    public NoiseGeneratorBOPByte byteNoiseGen;
    private World world;
    private final boolean mapFeaturesEnabled;
    private BOPWorldSettings settings;
    private IBlockState seaBlockState;
    private IBlockState stoneBlockState;
    private MapGenBase caveGenerator;
    private MapGenStronghold strongholdGenerator;
    private MapGenVillage villageGenerator;
    private MapGenMineshaft mineshaftGenerator;
    private MapGenScatteredFeature scatteredFeatureGenerator;
    private MapGenBase ravineGenerator;
    private StructureOceanMonument oceanMonumentGenerator;
    private WoodlandMansion woodlandMansionGenerator;
    private double[] xyzBalanceNoiseArray;
    private double[] xyzNoiseArrayA;
    private double[] xyzNoiseArrayB;
    private double[] stoneNoiseArray;
    private final double[] noiseArray;
    private Map<Biome, TerrainSettings> biomeTerrainSettings;
    private static float[] radialFalloff5x5 = new float[25];
    private static float[] radialStrongFalloff5x5 = new float[25];

    public ChunkGeneratorOverworldBOP(World worldIn, long seed, boolean mapFeaturesEnabled, String chunkProviderSettingsString) {
        System.out.println("ChunkGeneratorOverworldBOP json: " + chunkProviderSettingsString);
        this.world = worldIn;
        this.mapFeaturesEnabled = mapFeaturesEnabled;
        this.rand = new Random(seed);
        this.settings = new BOPWorldSettings(chunkProviderSettingsString);
        System.out.println("ChunkGeneratorOverworldBOP settings: " + this.settings.toJson());
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)new BOPMapGenScatteredFeature(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)new StructureOceanMonument(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.woodlandMansionGenerator = new WoodlandMansion((ChunkGeneratorOverworld)new FakeMansionChunkProvider());
        this.xyzNoiseGenA = new NoiseGeneratorOctaves(this.rand, 16);
        this.xyzNoiseGenB = new NoiseGeneratorOctaves(this.rand, 16);
        this.xyzBalanceNoiseGen = new NoiseGeneratorOctaves(this.rand, 8);
        this.stoneNoiseGen = new NoiseGeneratorPerlin(this.rand, 4);
        this.byteNoiseGen = new NoiseGeneratorBOPByte(this.rand, 6, 5, 5);
        this.stoneNoiseArray = new double[256];
        this.noiseArray = new double[825];
        this.stoneBlockState = Blocks.field_150348_b.func_176223_P();
        this.seaBlockState = Blocks.field_150355_j.func_176223_P();
        this.biomeTerrainSettings = new HashMap<Biome, TerrainSettings>();
        for (Biome biome : BiomeUtils.getRegisteredBiomes()) {
            if (biome == null) continue;
            this.biomeTerrainSettings.put(biome, biome instanceof BOPOverworldBiome ? ((BOPOverworldBiome)biome).terrainSettings : TerrainSettings.forVanillaBiome(biome));
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setChunkAirStoneWater(chunkX, chunkZ, chunkprimer);
        Biome[] biomes = this.world.func_72959_q().func_76933_b(null, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBlocksForBiome(chunkX, chunkZ, chunkprimer, biomes);
        boolean enableFeatures = true;
        String biomeName = this.world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16)).getRegistryName().toString().toLowerCase();
        if (biomeName == null || biomeName.equalsIgnoreCase("biomesoplenty:mystic_grove")) {
            enableFeatures = false;
        }
        if (enableFeatures) {
            if (this.settings.useCaves) {
                this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
            }
            if (this.settings.useRavines) {
                this.ravineGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
            }
            if (this.mapFeaturesEnabled) {
                if (this.settings.useMineShafts) {
                    this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
                }
                if (this.settings.useVillages) {
                    this.villageGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
                }
                if (this.settings.useStrongholds) {
                    this.strongholdGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
                }
                if (this.settings.useTemples) {
                    this.scatteredFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
                }
                if (this.settings.useMonuments) {
                    this.oceanMonumentGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
                }
                if (this.settings.useMansions) {
                    this.woodlandMansionGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
                }
            }
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, chunkX, chunkZ);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int k = 0; k < chunkBiomes.length; ++k) {
            chunkBiomes[k] = (byte)Biome.func_185362_a((Biome)biomes[k]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void setChunkAirStoneWater(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.populateNoiseArray(chunkX, chunkZ);
        double oneEighth = 0.125;
        double oneQuarter = 0.25;
        for (int ix = 0; ix < 4; ++ix) {
            int k_x0 = ix * 5;
            int k_x1 = (ix + 1) * 5;
            for (int iz = 0; iz < 4; ++iz) {
                int k_x0z0 = (k_x0 + iz) * 33;
                int k_x0z1 = (k_x0 + iz + 1) * 33;
                int k_x1z0 = (k_x1 + iz) * 33;
                int k_x1z1 = (k_x1 + iz + 1) * 33;
                for (int iy = 0; iy < 32; ++iy) {
                    double n_x0y0z0 = this.noiseArray[k_x0z0 + iy];
                    double n_x0y0z1 = this.noiseArray[k_x0z1 + iy];
                    double n_x1y0z0 = this.noiseArray[k_x1z0 + iy];
                    double n_x1y0z1 = this.noiseArray[k_x1z1 + iy];
                    double n_x0y1z0 = this.noiseArray[k_x0z0 + iy + 1];
                    double n_x0y1z1 = this.noiseArray[k_x0z1 + iy + 1];
                    double n_x1y1z0 = this.noiseArray[k_x1z0 + iy + 1];
                    double n_x1y1z1 = this.noiseArray[k_x1z1 + iy + 1];
                    double noiseStepY00 = (n_x0y1z0 - n_x0y0z0) * oneEighth;
                    double noiseStepY01 = (n_x0y1z1 - n_x0y0z1) * oneEighth;
                    double noiseStepY10 = (n_x1y1z0 - n_x1y0z0) * oneEighth;
                    double noiseStepY11 = (n_x1y1z1 - n_x1y0z1) * oneEighth;
                    double noiseStartX0 = n_x0y0z0;
                    double noiseStartX1 = n_x0y0z1;
                    double noiseEndX0 = n_x1y0z0;
                    double noiseEndX1 = n_x1y0z1;
                    for (int jy = 0; jy < 8; ++jy) {
                        double noiseStartZ = noiseStartX0;
                        double noiseEndZ = noiseStartX1;
                        double noiseStepX0 = (noiseEndX0 - noiseStartX0) * oneQuarter;
                        double noiseStepX1 = (noiseEndX1 - noiseStartX1) * oneQuarter;
                        for (int jx = 0; jx < 4; ++jx) {
                            double noiseStepZ = (noiseEndZ - noiseStartZ) * oneQuarter;
                            double noiseVal = noiseStartZ;
                            for (int jz = 0; jz < 4; ++jz) {
                                if (noiseVal > 0.0) {
                                    primer.func_177855_a(ix * 4 + jx, iy * 8 + jy, iz * 4 + jz, this.stoneBlockState);
                                } else if (iy * 8 + jy < this.settings.seaLevel) {
                                    primer.func_177855_a(ix * 4 + jx, iy * 8 + jy, iz * 4 + jz, this.seaBlockState);
                                }
                                noiseVal += noiseStepZ;
                            }
                            noiseStartZ += noiseStepX0;
                            noiseEndZ += noiseStepX1;
                        }
                        noiseStartX0 += noiseStepY00;
                        noiseStartX1 += noiseStepY01;
                        noiseEndX0 += noiseStepY10;
                        noiseEndX1 += noiseStepY11;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] biomes) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        this.stoneNoiseArray = this.stoneNoiseGen.func_151599_a(this.stoneNoiseArray, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                Biome biome = biomes[localZ + localX * 16];
                biome.func_180622_a(this.world, this.rand, primer, chunkX * 16 + localX, chunkZ * 16 + localZ, this.stoneNoiseArray[localZ + localX * 16]);
            }
        }
    }

    private TerrainSettings getWeightedTerrainSettings(int localX, int localZ, Biome[] biomes) {
        Biome centerBiome = biomes[localX + 2 + (localZ + 2) * 10];
        if (centerBiome == Biomes.field_76781_i || centerBiome == Biomes.field_76777_m || centerBiome instanceof BOPOverworldBiome && ((BOPOverworldBiome)centerBiome).noNeighborTerrainInfuence) {
            return this.biomeTerrainSettings.get(centerBiome);
        }
        TerrainSettings settings = new TerrainSettings();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float weight = radialFalloff5x5[i + 2 + (j + 2) * 5];
                TerrainSettings biomeSettings = this.biomeTerrainSettings.get(biomes[localX + i + 2 + (localZ + j + 2) * 10]);
                if (biomeSettings == null) continue;
                settings.avgHeight += (double)weight * biomeSettings.avgHeight;
                settings.variationAbove += (double)weight * biomeSettings.variationAbove;
                settings.variationBelow += (double)weight * biomeSettings.variationBelow;
                settings.minHeight += (double)weight * biomeSettings.minHeight;
                settings.maxHeight += (double)weight * biomeSettings.maxHeight;
                settings.sidewaysNoiseAmount += (double)weight * biomeSettings.sidewaysNoiseAmount;
                for (int k = 0; k < settings.octaveWeights.length; ++k) {
                    int n = k;
                    settings.octaveWeights[n] = settings.octaveWeights[n] + (double)weight * biomeSettings.octaveWeights[k];
                }
            }
        }
        return settings;
    }

    private void populateNoiseArray(int chunkX, int chunkZ) {
        Biome[] biomes = this.world.func_72959_q().func_76937_a(null, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        float coordinateScale = this.settings.coordinateScale;
        float heightScale = this.settings.heightScale;
        double upperLimitScale = this.settings.upperLimitScale;
        double lowerLimitScale = this.settings.lowerLimitScale;
        float mainNoiseScaleX = this.settings.mainNoiseScaleX;
        float mainNoiseScaleY = this.settings.mainNoiseScaleY;
        float mainNoiseScaleZ = this.settings.mainNoiseScaleZ;
        int subchunkX = chunkX * 4;
        int subchunkY = 0;
        int subchunkZ = chunkZ * 4;
        this.byteNoiseGen.generateNoise(subchunkX, subchunkZ);
        this.xyzBalanceNoiseArray = this.xyzBalanceNoiseGen.func_76304_a(this.xyzBalanceNoiseArray, subchunkX, subchunkY, subchunkZ, 5, 33, 5, (double)(coordinateScale / mainNoiseScaleX), (double)(heightScale / mainNoiseScaleY), (double)(coordinateScale / mainNoiseScaleZ));
        this.xyzNoiseArrayA = this.xyzNoiseGenA.func_76304_a(this.xyzNoiseArrayA, subchunkX, subchunkY, subchunkZ, 5, 33, 5, (double)coordinateScale, (double)heightScale, (double)coordinateScale);
        this.xyzNoiseArrayB = this.xyzNoiseGenB.func_76304_a(this.xyzNoiseArrayB, subchunkX, subchunkY, subchunkZ, 5, 33, 5, (double)coordinateScale, (double)heightScale, (double)coordinateScale);
        int xyzCounter = 0;
        int xzCounter = 0;
        for (int ix = 0; ix < 5; ++ix) {
            for (int iz = 0; iz < 5; ++iz) {
                TerrainSettings settings = this.getWeightedTerrainSettings(ix, iz, biomes);
                double xzNoiseVal = this.byteNoiseGen.getWeightedDouble(xzCounter, settings.octaveWeights);
                double xzAmplitude = (double)this.settings.amplitude * (xzNoiseVal < 0.0 ? settings.variationBelow : settings.variationAbove) * (1.0 - settings.sidewaysNoiseAmount);
                double xyzAmplitude = (double)this.settings.amplitude * (xzNoiseVal < 0.0 ? settings.variationBelow : settings.variationAbove) * settings.sidewaysNoiseAmount;
                double baseLevel = settings.avgHeight + xzNoiseVal * xzAmplitude;
                for (int iy = 0; iy < 33; ++iy) {
                    int y = iy * 8;
                    if ((double)y < settings.minHeight) {
                        this.noiseArray[xyzCounter] = settings.minHeight - (double)y;
                    } else if ((double)y > settings.maxHeight) {
                        this.noiseArray[xyzCounter] = settings.maxHeight - (double)y;
                    } else {
                        double xyzNoiseA = this.xyzNoiseArrayA[xyzCounter] / lowerLimitScale;
                        double xyzNoiseB = this.xyzNoiseArrayB[xyzCounter] / upperLimitScale;
                        double balance = (this.xyzBalanceNoiseArray[xyzCounter] / 10.0 + 1.0) / 2.0;
                        double xyzNoiseValue = MathHelper.func_151237_a((double)xyzNoiseA, (double)xyzNoiseB, (double)balance) / 50.0;
                        double depth = baseLevel - (double)y + xyzAmplitude * xyzNoiseValue;
                        if (iy > 29) {
                            double closeToTopOfChunkFactor = (float)(iy - 29) / 3.0f;
                            depth = depth * (1.0 - closeToTopOfChunkFactor) + -10.0 * closeToTopOfChunkFactor;
                        }
                        this.noiseArray[xyzCounter] = depth;
                    }
                    ++xyzCounter;
                }
                ++xzCounter;
            }
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int i;
        BlockPos target;
        boolean prevLogging = ForgeModContainer.logCascadingWorldGeneration;
        ForgeModContainer.logCascadingWorldGeneration = false;
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos blockpos = new BlockPos(x, 0, z);
        Biome Biome2 = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long l0 = this.rand.nextLong() / 2L * 2L + 1L;
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * l0 + (long)chunkZ * l1 ^ this.world.func_72905_C());
        boolean hasVillageGenerated = false;
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.world, this.rand, chunkX, chunkZ, hasVillageGenerated));
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useVillages) {
                hasVillageGenerated = this.villageGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
            if (this.settings.useMansions) {
                this.woodlandMansionGenerator.func_175794_a(this.world, this.rand, chunkPos);
            }
        }
        BlockPos decorateStart = blockpos.func_177982_a(8, 0, 8);
        if (Biome2.func_76727_i() > 0.01f && Biome2 != Biomes.field_76769_d && Biome2 != Biomes.field_76786_s && this.settings.useWaterLakes && !hasVillageGenerated && this.rand.nextInt(this.settings.waterLakeChance) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            target = decorateStart.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(256), this.rand.nextInt(16));
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, target);
        }
        if (!hasVillageGenerated && BOPBiomes.redwood_forest.isPresent() && Biome2 != BOPBiomes.redwood_forest.get() && BOPBiomes.redwood_forest_edge.isPresent() && Biome2 != BOPBiomes.redwood_forest_edge.get() && BOPBiomes.wasteland.isPresent() && Biome2 != BOPBiomes.wasteland.get() && this.rand.nextInt(this.settings.lavaLakeChance / 10) == 0 && this.settings.useLavaLakes && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && ((target = decorateStart.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(248) + 8, this.rand.nextInt(16))).func_177956_o() < 63 || this.rand.nextInt(this.settings.lavaLakeChance / 8) == 0)) {
            new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, target);
        }
        if (this.settings.useDungeons && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (i = 0; i < this.settings.dungeonChance; ++i) {
                target = decorateStart.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(256), this.rand.nextInt(16));
                new WorldGenDungeons().func_180709_b(this.world, this.rand, target);
            }
        }
        Biome2.func_180624_a(this.world, this.rand, new BlockPos(x, 0, z));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)Biome2, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    target = this.world.func_175725_q(decorateStart.func_177982_a(i, 0, j));
                    Biome biome = this.world.func_180494_b(target);
                    if (this.world.func_175675_v(target.func_177977_b())) {
                        this.world.func_180501_a(target.func_177977_b(), Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!(biome.func_76727_i() > 0.01f) || !this.world.func_175708_f(target, true)) continue;
                    this.world.func_180501_a(target, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.world, this.rand, chunkX, chunkZ, hasVillageGenerated));
        BlockFalling.field_149832_M = false;
        ForgeModContainer.logCascadingWorldGeneration = prevLogging;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        boolean flag = false;
        if (this.settings.useMonuments && this.mapFeaturesEnabled && chunkIn.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome Biome2 = this.world.func_180494_b(pos);
        if (this.mapFeaturesEnabled) {
            if (creatureType == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.func_175798_a(pos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (creatureType == EnumCreatureType.MONSTER && this.settings.useMonuments && this.oceanMonumentGenerator.func_175796_a(this.world, pos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        }
        return Biome2.func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean findUnexplored) {
        return !this.mapFeaturesEnabled ? null : ("Stronghold".equals(structureName) && this.strongholdGenerator != null ? this.strongholdGenerator.func_180706_b(world, pos, findUnexplored) : ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null ? this.woodlandMansionGenerator.func_180706_b(world, pos, findUnexplored) : ("Monument".equals(structureName) && this.oceanMonumentGenerator != null ? this.oceanMonumentGenerator.func_180706_b(world, pos, findUnexplored) : ("Village".equals(structureName) && this.villageGenerator != null ? this.villageGenerator.func_180706_b(world, pos, findUnexplored) : ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null ? this.mineshaftGenerator.func_180706_b(world, pos, findUnexplored) : ("Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_180706_b(world, pos, findUnexplored) : null))))));
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useVillages) {
                this.villageGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useMansions) {
                this.woodlandMansionGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
        }
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_175795_b(pos);
        }
        if ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null) {
            return this.woodlandMansionGenerator.func_175795_b(pos);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_175795_b(pos);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_175795_b(pos);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null && this.scatteredFeatureGenerator.func_175795_b(pos);
    }

    static {
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                ChunkGeneratorOverworldBOP.radialFalloff5x5[j + 2 + (k + 2) * 5] = 0.064761624f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
                ChunkGeneratorOverworldBOP.radialStrongFalloff5x5[j + 2 + (k + 2) * 5] = 0.07616052f / ((float)(j * j + k * k) + 0.2f);
            }
        }
    }

    private class FakeMansionChunkProvider
    extends ChunkGeneratorOverworld {
        public FakeMansionChunkProvider() {
            super(ChunkGeneratorOverworldBOP.this.world, 0L, true, "");
        }

        public void func_185976_a(int x, int z, ChunkPrimer primer) {
            ChunkGeneratorOverworldBOP.this.setChunkAirStoneWater(x, z, primer);
        }
    }
}

