/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorBlobs;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorSplotches;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class BiomeGenColdDesert
extends BOPOverworldBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;

    public BiomeGenColdDesert() {
        super("cold_desert", new BOPBiome.PropsBuilder("Cold Desert").withGuiColour(11775899).withTemperature(Float.valueOf(0.2f)).withRainfall(Float.valueOf(0.0f)));
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        if (BOPBiomes.gravel_beach.isPresent()) {
            this.beachBiomeLocation = ((BOPOverworldBiome)BOPBiomes.gravel_beach.get()).getResourceLocation();
        }
        this.terrainSettings.avgHeight(64.0).heightVariation(5.0, 10.0).sidewaysNoise(0.7);
        this.field_76752_A = Blocks.field_150351_n.func_176223_P();
        this.field_76753_B = Blocks.field_150348_b.func_176223_P();
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = Blocks.field_150433_aE.func_176223_P();
        this.canGenerateRivers = false;
        this.addWeight(BOPClimates.ICE_CAP, 10);
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityPolarBear.class, 1, 1, 2));
        BlockQuery.BlockQueryBlock surface = new BlockQuery.BlockQueryBlock(Blocks.field_150348_b, Blocks.field_150351_n);
        this.addGenerator("stone_patches", GeneratorStage.SAND, ((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)new GeneratorSplotches.Builder().amountPerChunk(6.0f)).splotchSize(24).placeOn(surface)).replace(surface)).with(Blocks.field_150348_b.func_176223_P())).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE)).create());
        this.addGenerator("boulders", GeneratorStage.SAND_PASS2, ((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)((GeneratorBlobs.Builder)new GeneratorBlobs.Builder().amountPerChunk(0.2f)).placeOn(surface)).with(Blocks.field_150347_e.func_176223_P())).minRadius(1.0f).maxRadius(3.0f).numBalls(4).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE)).create());
        this.addGenerator("tanzanite", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.TANZANITE)).create());
    }

    @Override
    public void configure(IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        this.field_76752_A = noise + rand.nextDouble() * 3.0 > 1.8 ? this.alternateTopBlock : this.usualTopBlock;
        super.func_180622_a(world, rand, primer, x, z, noise);
    }
}

