/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.betterdisplays;

import com.windanesz.betterdisplays.BetterDisplays;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public final class Settings {
    public static final String MAIN_CONFIG = "settings";
    private Configuration config;
    public String[] whitelistedBookItems = new String[0];
    public boolean displayItemNames = true;
    public boolean displayItemNamesOnlyWhileSneaking = false;

    void initConfig(FMLPreInitializationEvent event) {
        this.config = new Configuration(new File(BetterDisplays.configDirectory, "betterdisplays.cfg"));
        this.config.load();
        BetterDisplays.logger.info("Setting up main config");
        this.setupConfig();
        this.config.save();
    }

    void saveConfigChanges() {
        BetterDisplays.logger.info("Saving in-game config changes");
        this.setupConfig();
        this.config.save();
    }

    public ConfigCategory getConfigCategory(String name) {
        return this.config.getCategory(name);
    }

    private void setupConfig() {
        ArrayList<String> propOrder = new ArrayList<String>();
        this.config.addCustomCategoryComment(MAIN_CONFIG, "Settings of the Better Displays mod");
        Property property = this.config.get(MAIN_CONFIG, "whitelistedBookItems", new String[]{"antiqueatlas:antique_atlas"}, "List of items which are allowed to be inserted into the Book Holder block.");
        property.setLanguageKey("config.betterdisplays.whitelisted_book_items");
        property.setRequiresMcRestart(false);
        this.whitelistedBookItems = property.getStringList();
        propOrder.add(property.getName());
        property = this.config.get(MAIN_CONFIG, "displayItemNames", true, "If true, Display Cases and Book Holders will display the name of the item they contain when the player looks at them.");
        property.setLanguageKey("config.betterdisplays.display_item_names");
        property.setRequiresMcRestart(false);
        this.displayItemNames = property.getBoolean();
        propOrder.add(property.getName());
        property = this.config.get(MAIN_CONFIG, "displayItemNamesOnlyWhileSneaking", true, "If true, Display Cases and Book Holders will only display the name of the item they contain when the player looks at them while sneaking.");
        property.setLanguageKey("config.betterdisplays.display_item_names_only_while_sneaking");
        property.setRequiresMcRestart(false);
        this.displayItemNamesOnlyWhileSneaking = property.getBoolean();
        propOrder.add(property.getName());
        this.config.setCategoryPropertyOrder(MAIN_CONFIG, propOrder);
    }

    public boolean isAllowedBookItem(ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            String registryName = itemStack.func_77973_b().getRegistryName().toString().toLowerCase();
            String itemName = itemStack.func_77973_b().getRegistryName().func_110623_a();
            List<String> list = Arrays.asList(BetterDisplays.settings.whitelistedBookItems);
            if (list.contains(registryName)) {
                return true;
            }
            Pattern pattern = Pattern.compile("(?!.*book_holder.*)(book|tome|codex|compendium|guide|journal|lexicon)", 2);
            Matcher matcher = pattern.matcher(itemName);
            if (matcher.find()) {
                return true;
            }
        }
        return false;
    }
}

