/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.commands;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import silly511.backups.BackupsMod;
import silly511.backups.commands.RestoreCommand;
import silly511.backups.gui.GuiRestoreTask;
import silly511.backups.helpers.BackupHelper;

public class RestoreWorldCommandClient
extends CommandBase {
    private static final AtomicReference<Runnable> clientTickTask = new AtomicReference();

    public String func_71517_b() {
        return "restoreworld";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.backups.restoreworld.usage";
    }

    public int func_82362_a() {
        return 4;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return RestoreCommand.getListOfBackups(args);
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("commands.backups.restoreworld.usage", new Object[0]);
        }
        File worldDir = DimensionManager.getCurrentSaveRootDirectory();
        BackupHelper.Backup backup = RestoreCommand.parseBackup(args[0]);
        Minecraft mc = Minecraft.func_71410_x();
        BackupsMod.logger.info("Shutting server down to restore backup");
        clientTickTask.set(() -> {
            mc.field_71441_e.func_72882_A();
            mc.func_71403_a(null);
            mc.func_147108_a((GuiScreen)new GuiRestoreTask(null, status -> {
                status.accept("gui.backups.restoring");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BackupHelper.restoreBackup(backup.dir, worldDir, new File("temp"), null);
                BackupHelper.setLastBackup(backup.dir.getParentFile(), backup.dir);
            }));
        });
    }

    public static void onPreClientTick() {
        Runnable task = clientTickTask.getAndSet(null);
        if (task != null) {
            task.run();
        }
    }
}

