/*
 * Decompiled with CFR 0.152.
 */
package com.lazerzes.anvils.handler;

import com.lazerzes.anvils.api.IModPlugin;
import com.lazerzes.anvils.api.anvil.AnvilRecipe;
import com.lazerzes.anvils.registry.AnvilRegistry;
import com.lazerzes.anvils.util.GsonHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnvilRecipeHandler {
    public static ArrayList<AnvilRecipe> registeredRecipes = new ArrayList();

    public static void initPlugins(File base_dir, ArrayList<IModPlugin> modPlugins, AnvilRegistry anvilRegistry) {
        String[] child_dirs;
        for (IModPlugin plugin : modPlugins) {
            String mod_name = plugin.getPluginId();
            File child_dir = new File(base_dir, mod_name);
            if (child_dir.exists() || !child_dir.mkdirs()) continue;
            AnvilRegistry tmp = new AnvilRegistry();
            plugin.registerRecipes(tmp);
            for (Pair<String, AnvilRecipe> pair : tmp.getFileRecipes()) {
                String json = GsonHelper.GSON.toJson(pair.getRight());
                try {
                    FileWriter writer = new FileWriter(new File(child_dir, (String)pair.getLeft() + ".json"));
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            tmp.clearFiles();
            anvilRegistry.joinRegistry(tmp);
        }
        for (String child : child_dirs = base_dir.list((FilenameFilter)FileFilterUtils.directoryFileFilter())) {
            File child_dir = new File(base_dir, child);
            File[] files = child_dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
            if (files == null) continue;
            for (File file : files) {
                try {
                    FileReader reader = new FileReader(file);
                    AnvilRecipe anvilRecipe = (AnvilRecipe)GsonHelper.GSON.fromJson((Reader)reader, AnvilRecipe.class);
                    anvilRegistry.addRecipe(anvilRecipe);
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

