/*
 * Decompiled with CFR 0.152.
 */
package com.lazerzes.anvils;

import com.lazerzes.anvils.api.IModPlugin;
import com.lazerzes.anvils.api.anvil.AnvilRecipe;
import com.lazerzes.anvils.handler.AnvilRecipeHandler;
import com.lazerzes.anvils.registry.AnvilRegistry;
import com.lazerzes.anvils.util.AnnotationHelper;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="anvils", name="Anvil Enchantments", version="2.0.3", dependencies="before:guide-api;", acceptedMinecraftVersions="[1.12.2]")
public class AnvilEnchantments {
    private static File configDir;
    private static ArrayList<IModPlugin> modPlugins;
    public static AnvilRegistry anvilRegistry;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDir = new File(event.getModConfigurationDirectory(), "anvils");
        ASMDataTable asmDataTable = event.getAsmData();
        modPlugins = AnnotationHelper.getPlugins(asmDataTable);
        AnnotationHelper.ensureVanilla(modPlugins);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        anvilRegistry = new AnvilRegistry();
        AnvilRecipeHandler.initPlugins(new File(configDir, "recipes"), modPlugins, anvilRegistry);
        CreativeTabs TAB_ANV = new CreativeTabs("anvils"){

            public ItemStack func_78016_d() {
                return new ItemStack(Blocks.field_150467_bQ, 1);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(NonNullList<ItemStack> dispList) {
                for (AnvilRecipe r : anvilRegistry.getRuntimeRecipes()) {
                    if (!r.showRecipe) continue;
                    dispList.add((Object)r.getAnvilOutput());
                }
            }
        };
    }
}

