/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item.tome;

import cofh.api.fluid.IFluidContainerItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.util.CoreUtils;
import cofh.core.util.capabilities.FluidContainerItemWrapper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.tome.ItemTome;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemTomeExperience
extends ItemTome
implements IFluidContainerItem,
IEnchantableItem {
    public static final int CAPACITY = 10000;
    public static boolean enable = true;
    public static ItemStack tomeExperience;

    public ItemTomeExperience() {
        this.func_77655_b("experience");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.tome.experience.0"));
        tooltip.add(StringHelper.localize((String)"info.thermalfoundation.tome.experience.1"));
        tooltip.add(StringHelper.getNoticeText((String)"info.thermalfoundation.tome.experience.2"));
        tooltip.add(StringHelper.localize((String)"info.cofh.experience") + ": " + StringHelper.formatNumber((long)ItemTomeExperience.getExperience(stack)) + " / " + StringHelper.formatNumber((long)ItemTomeExperience.getMaxExperience(stack)));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable) {
            super.func_150895_a(tab, items);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!this.isEmpowered(stack)) {
            return;
        }
        NBTTagCompound tag = entity.getEntityData();
        tag.func_74772_a("thermalfoundation.experience_timer", entity.field_70170_p.func_82737_E());
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Experience"}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 10;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 8039506;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return MathHelper.clamp((double)(1.0 - (double)ItemTomeExperience.getExperience(stack) / (double)ItemTomeExperience.getMaxExperience(stack)), (double)0.0, (double)1.0);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND || ServerHelper.isClientWorld((World)world)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        int curLevel = player.field_71068_ca;
        if (player.func_70093_af()) {
            if (ItemTomeExperience.getExtraPlayerExperience(player) > 0) {
                int exp = Math.min(ItemTomeExperience.getTotalExpForLevel(player.field_71068_ca + 1) - ItemTomeExperience.getTotalExpForLevel(player.field_71068_ca) - ItemTomeExperience.getExtraPlayerExperience(player), ItemTomeExperience.getExperience(stack));
                ItemTomeExperience.setPlayerExperience(player, ItemTomeExperience.getPlayerExperience(player) + exp);
                if (player.field_71068_ca < curLevel + 1 && ItemTomeExperience.getPlayerExperience(player) >= ItemTomeExperience.getTotalExpForLevel(curLevel + 1)) {
                    ItemTomeExperience.setPlayerLevel(player, curLevel + 1);
                }
                ItemTomeExperience.modifyExperience(stack, -exp);
            } else {
                int exp = Math.min(ItemTomeExperience.getTotalExpForLevel(player.field_71068_ca + 1) - ItemTomeExperience.getTotalExpForLevel(player.field_71068_ca), ItemTomeExperience.getExperience(stack));
                ItemTomeExperience.setPlayerExperience(player, ItemTomeExperience.getPlayerExperience(player) + exp);
                if (player.field_71068_ca < curLevel + 1 && ItemTomeExperience.getPlayerExperience(player) >= ItemTomeExperience.getTotalExpForLevel(curLevel + 1)) {
                    ItemTomeExperience.setPlayerLevel(player, curLevel + 1);
                }
                ItemTomeExperience.modifyExperience(stack, -exp);
            }
        } else if (ItemTomeExperience.getExtraPlayerExperience(player) > 0) {
            int exp = Math.min(ItemTomeExperience.getExtraPlayerExperience(player), ItemTomeExperience.getSpace(stack));
            ItemTomeExperience.setPlayerExperience(player, ItemTomeExperience.getPlayerExperience(player) - exp);
            if (player.field_71068_ca < curLevel) {
                ItemTomeExperience.setPlayerLevel(player, curLevel);
            }
            ItemTomeExperience.modifyExperience(stack, exp);
        } else if (player.field_71068_ca > 0) {
            int exp = Math.min(ItemTomeExperience.getTotalExpForLevel(player.field_71068_ca) - ItemTomeExperience.getTotalExpForLevel(player.field_71068_ca - 1), ItemTomeExperience.getSpace(stack));
            ItemTomeExperience.setPlayerExperience(player, ItemTomeExperience.getPlayerExperience(player) - exp);
            if (player.field_71068_ca < curLevel - 1) {
                ItemTomeExperience.setPlayerLevel(player, curLevel - 1);
            }
            ItemTomeExperience.modifyExperience(stack, exp);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public static int getExperience(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74762_e("Experience");
    }

    public static int getSpace(ItemStack stack) {
        return ItemTomeExperience.getMaxExperience(stack) - ItemTomeExperience.getExperience(stack);
    }

    public static int getMaxExperience(ItemStack stack) {
        return 10000 + 10000 * EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack) / 2;
    }

    public static int modifyExperience(ItemStack stack, int exp) {
        int storedExp = ItemTomeExperience.getExperience(stack) + exp;
        if (storedExp > ItemTomeExperience.getMaxExperience(stack)) {
            storedExp = ItemTomeExperience.getMaxExperience(stack);
        } else if (storedExp < 0) {
            storedExp = 0;
        }
        stack.func_77978_p().func_74768_a("Experience", storedExp);
        return storedExp;
    }

    public static int getPlayerExperience(EntityPlayer player) {
        return ItemTomeExperience.getTotalExpForLevel(player.field_71068_ca) + ItemTomeExperience.getExtraPlayerExperience(player);
    }

    public static int getLevelPlayerExperience(EntityPlayer player) {
        return ItemTomeExperience.getTotalExpForLevel(player.field_71068_ca);
    }

    public static int getExtraPlayerExperience(EntityPlayer player) {
        return Math.round(player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void setPlayerExperience(EntityPlayer player, int exp) {
        player.field_71068_ca = 0;
        player.field_71106_cc = 0.0f;
        player.field_71067_cb = 0;
        ItemTomeExperience.addExperienceToPlayer(player, exp);
    }

    public static void setPlayerLevel(EntityPlayer player, int level) {
        player.field_71068_ca = level;
        player.field_71106_cc = 0.0f;
    }

    public static void addExperienceToPlayer(EntityPlayer player, int exp) {
        int i = Integer.MAX_VALUE - player.field_71067_cb;
        if (exp > i) {
            exp = i;
        }
        player.field_71106_cc += (float)exp / (float)player.func_71050_bK();
        player.field_71067_cb += exp;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            ItemTomeExperience.addExperienceLevelToPlayer(player, 1);
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static void addExperienceLevelToPlayer(EntityPlayer player, int levels) {
        player.field_71068_ca += levels;
        if (player.field_71068_ca < 0) {
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
            player.field_71067_cb = 0;
        }
    }

    public static int getTotalExpForLevel(int level) {
        return level >= 32 ? (9 * level * level - 325 * level + 4440) / 2 : (level >= 17 ? (5 * level * level - 81 * level + 720) / 2 : level * level + 6 * level);
    }

    public static boolean onXPPickup(PlayerPickupXpEvent event, ItemStack stack) {
        EntityXPOrb orb = event.getOrb();
        int toAdd = Math.min(ItemTomeExperience.getSpace(stack), orb.field_70530_e);
        if (toAdd > 0) {
            stack.func_190915_d(5);
            EntityPlayer player = event.getEntityPlayer();
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, (MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.35f + 0.9f);
            ItemTomeExperience.modifyExperience(stack, toAdd);
            orb.field_70530_e -= toAdd;
            if (orb.field_70530_e <= 0) {
                orb.func_70106_y();
            }
        }
        return orb.field_70128_L;
    }

    public FluidStack getFluid(ItemStack container) {
        int experience = ItemTomeExperience.getExperience(container);
        return experience > 0 ? FluidRegistry.getFluidStack((String)"xpjuice", (int)(experience * 20)) : null;
    }

    public int getCapacity(ItemStack container) {
        return ItemTomeExperience.getMaxExperience(container) * 20;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != TFFluids.fluidExperience && !resource.getFluid().getName().equals("essence") && !resource.getFluid().getName().equals("xpjuice")) {
            return 0;
        }
        int experience = ItemTomeExperience.getExperience(container);
        int filled = Math.min(ItemTomeExperience.getMaxExperience(container) - experience, resource.amount / 20);
        if (doFill) {
            ItemTomeExperience.modifyExperience(container, filled);
        }
        return filled * 20;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        int experience = ItemTomeExperience.getExperience(container);
        if (experience <= 0) {
            return null;
        }
        int drained = Math.min(experience, maxDrain / 20);
        if (doDrain) {
            ItemTomeExperience.modifyExperience(container, -drained);
        }
        return FluidRegistry.getFluidStack((String)"xpjuice", (int)(drained * 20));
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidContainerItemWrapper(stack, (IFluidContainerItem)this, false, true);
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("tome_experience"));
        ThermalFoundation.proxy.addIModelRegister(this);
        ItemTomeExperience.config();
        tomeExperience = new ItemStack((Item)this);
        return true;
    }

    public boolean initialize() {
        if (enable) {
            RecipeHelper.addShapedRecipe((ItemStack)tomeExperience, (Object[])new Object[]{" L ", "EBE", " L ", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('E'), "gemEmerald", Character.valueOf('L'), "gemLapis"});
        }
        return true;
    }

    public static void config() {
        String category = "Tome.Experience";
        String comment = "If TRUE, the recipe for the Tome of Knowledge is enabled. Set this to FALSE only if you know what you are doing and/or want to create needless inconvenience.";
        enable = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnableRecipe", category, enable, comment);
    }
}

