/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.api.core.ISecurable;
import cofh.api.item.IUpgradeItem;
import cofh.api.tileentity.IUpgradeable;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFProps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemUpgrade
extends ItemMulti
implements IInitializer,
IUpgradeItem {
    private Int2ObjectOpenHashMap<UpgradeEntry> upgradeMap = new Int2ObjectOpenHashMap();
    public static ItemStack[] upgradeIncremental;
    public static ItemStack[] upgradeFull;
    public static ItemStack upgradeCreative;

    public ItemUpgrade() {
        super("thermalfoundation");
        this.func_77655_b("upgrade");
        this.func_77637_a(ThermalFoundation.tabUtils);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        IUpgradeItem.UpgradeType type = this.getUpgradeType(stack);
        switch (type) {
            case INCREMENTAL: {
                tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.upgrade.incremental.0"));
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalfoundation.upgrade.incremental.1"));
                break;
            }
            case FULL: {
                tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.upgrade.full.0"));
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalfoundation.upgrade.full.1"));
                break;
            }
            case CREATIVE: {
                tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.upgrade.creative.0"));
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalfoundation.upgrade.creative.1"));
                break;
            }
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!block.hasTileEntity(state)) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canPlayerAccess(player)) {
            return EnumActionResult.PASS;
        }
        if (tile instanceof IUpgradeable) {
            if (!((IUpgradeable)tile).canUpgrade(stack)) {
                return EnumActionResult.PASS;
            }
            if (ServerHelper.isServerWorld((World)world)) {
                if (((IUpgradeable)tile).installUpgrade(stack)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187698_i, SoundCategory.PLAYERS, 0.6f, 1.0f);
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalfoundation.upgrade.install.success", new Object[0]));
                } else {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalfoundation.upgrade.install.failure", new Object[0]));
                }
                return EnumActionResult.SUCCESS;
            }
            if (((IUpgradeable)tile).canUpgrade(stack)) {
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public IUpgradeItem.UpgradeType getUpgradeType(ItemStack stack) {
        return ((UpgradeEntry)this.upgradeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).type;
    }

    public byte getUpgradeLevel(ItemStack stack) {
        return ((UpgradeEntry)this.upgradeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level;
    }

    public boolean preInit() {
        byte level;
        int i;
        ForgeRegistries.ITEMS.register(this.setRegistryName("upgrade"));
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)this);
        upgradeIncremental = new ItemStack[4];
        for (i = 0; i < 4; ++i) {
            level = (byte)(i + 1);
            ItemUpgrade.upgradeIncremental[i] = this.addItem(i, "incremental" + level);
            this.addUpgradeEntry(i, IUpgradeItem.UpgradeType.INCREMENTAL, level);
        }
        upgradeFull = new ItemStack[4];
        for (i = 1; i < 4; ++i) {
            level = (byte)(i + 1);
            ItemUpgrade.upgradeFull[i] = this.addItem(32 + i, "full" + level);
            this.addUpgradeEntry(32 + i, IUpgradeItem.UpgradeType.FULL, level);
        }
        upgradeCreative = this.addItem(256, "creative");
        this.addUpgradeEntry(256, IUpgradeItem.UpgradeType.CREATIVE, (byte)4);
        return true;
    }

    public boolean initialize() {
        if (TFProps.disableUpgradeItems) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)upgradeIncremental[0], (Object[])new Object[]{" I ", "IGI", "DID", Character.valueOf('D'), "dustRedstone", Character.valueOf('G'), "gearBronze", Character.valueOf('I'), "ingotInvar"});
        RecipeHelper.addShapedRecipe((ItemStack)upgradeIncremental[1], (Object[])new Object[]{" I ", "IGI", "DID", Character.valueOf('D'), "blockGlassHardened", Character.valueOf('G'), "gearSilver", Character.valueOf('I'), "ingotElectrum"});
        RecipeHelper.addShapedRecipe((ItemStack)upgradeIncremental[2], (Object[])new Object[]{" I ", "IGI", "DID", Character.valueOf('D'), "dustCryotheum", Character.valueOf('G'), "gearElectrum", Character.valueOf('I'), "ingotSignalum"});
        RecipeHelper.addShapedRecipe((ItemStack)upgradeIncremental[3], (Object[])new Object[]{" I ", "IGI", "DID", Character.valueOf('D'), "dustPyrotheum", Character.valueOf('G'), "gearLumium", Character.valueOf('I'), "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)upgradeFull[1], (Object[])new Object[]{upgradeIncremental[0], upgradeIncremental[1]});
        RecipeHelper.addShapelessRecipe((ItemStack)upgradeFull[2], (Object[])new Object[]{upgradeFull[1], upgradeIncremental[2]});
        RecipeHelper.addShapelessRecipe((ItemStack)upgradeFull[2], (Object[])new Object[]{upgradeIncremental[0], upgradeIncremental[1], upgradeIncremental[2]});
        RecipeHelper.addShapelessRecipe((ItemStack)upgradeFull[3], (Object[])new Object[]{upgradeFull[2], upgradeIncremental[3]});
        RecipeHelper.addShapelessRecipe((ItemStack)upgradeFull[3], (Object[])new Object[]{upgradeFull[1], upgradeIncremental[2], upgradeIncremental[3]});
        RecipeHelper.addShapelessRecipe((ItemStack)upgradeFull[3], (Object[])new Object[]{upgradeIncremental[0], upgradeIncremental[1], upgradeIncremental[2], upgradeIncremental[3]});
        return true;
    }

    private void addUpgradeEntry(int metadata, IUpgradeItem.UpgradeType type, byte level) {
        this.upgradeMap.put(metadata, (Object)new UpgradeEntry(type, level));
    }

    public class UpgradeEntry {
        public final IUpgradeItem.UpgradeType type;
        public final byte level;

        UpgradeEntry(IUpgradeItem.UpgradeType type, byte level) {
            this.type = type;
            this.level = level;
        }
    }
}

