package jeresources.util;

import net.minecraft.util.text.translation.I18n;

public class TranslationHelper {
    public static String translateToLocal(String key) {
        return I18n.func_74838_a(key);
    }

    public static String getLocalPageInfo(int page, int lastPage) {
        return translateToLocal("jer.page") + " " + (page + 1) + " " + translateToLocal("jer.of") + " " + (lastPage + 1);
    }

    public static boolean canTranslate(String key) {
        return I18n.func_94522_b(key);
    }

    public static String tryDimensionTranslate(String dimension) {
        if (TranslationHelper.canTranslate("jer.dim." + dimension)) {
            dimension = "jer.dim." + dimension;
        }
        return TranslationHelper.translateToLocal(dimension);
    }
}
