/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.client.gui;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.venus.inventory.ContainerGeothermal;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityGeothermalGenerator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiGeothermal
extends GuiContainerGC {
    private static final ResourceLocation backgroundTexture = new ResourceLocation("galacticraftplanets", "textures/gui/geothermal.png");
    private final TileEntityGeothermalGenerator geothermalGenerator;
    private final GuiElementInfoRegion electricInfoRegion;
    private GuiButton buttonEnableSolar;

    public GuiGeothermal(InventoryPlayer par1InventoryPlayer, TileEntityGeothermalGenerator geothermalGenerator) {
        super((Container)new ContainerGeothermal(par1InventoryPlayer, geothermalGenerator));
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 107, (this.field_146295_m - this.field_147000_g) / 2 + 101, 56, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.geothermalGenerator = geothermalGenerator;
        this.field_147000_g = 201;
        this.field_146999_f = 176;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.geothermalGenerator.func_174877_v(), 0}));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energy_storage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.energy_storage.desc.1") + (int)Math.floor(this.geothermalGenerator.getEnergyStoredGC()) + " / " + (int)Math.floor(this.geothermalGenerator.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 96;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 24;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.battery_slot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 151, (this.field_146295_m - this.field_147000_g) / 2 + 82, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        this.buttonEnableSolar = new GuiButton(0, this.field_146294_l / 2 - 36, this.field_146295_m / 2 - 19, 72, 20, GCCoreUtil.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnableSolar);
    }

    protected void func_146979_b(int par1, int par2) {
        int offsetY = 35;
        this.buttonEnableSolar.field_146124_l = this.geothermalGenerator.disableCooldown == 0;
        this.buttonEnableSolar.field_146126_j = !this.geothermalGenerator.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.disable.name") : GCCoreUtil.translate((String)"gui.button.enable.name");
        String displayString = this.geothermalGenerator.func_70005_c_();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 7, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 22 + offsetY, 0x404040);
        displayString = this.getStatus2();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 33 + offsetY, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.generating.name") + ": " + (this.geothermalGenerator.generateWatts > 0 ? EnergyDisplayHelper.getEnergyDisplayS((float)this.geothermalGenerator.generateWatts) + "/t" : GCCoreUtil.translate((String)"gui.status.not_generating.name"));
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 11 + offsetY, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
    }

    private String getStatus() {
        if (this.geothermalGenerator.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (this.geothermalGenerator.generateWatts > 0) {
            return EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.collectingenergy.name");
        }
        if (!this.geothermalGenerator.hasValidSpout()) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.status.invalid_spout_1.name");
        }
        return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.unknown.name");
    }

    private String getStatus2() {
        if (this.geothermalGenerator.getDisabled(0) || this.geothermalGenerator.generateWatts > 0) {
            return "";
        }
        if (!this.geothermalGenerator.hasValidSpout()) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.status.invalid_spout_2.name");
        }
        return "";
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList electricityDesc = new ArrayList();
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.geothermalGenerator.getEnergyStoredGC(), (float)this.geothermalGenerator.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        if (this.geothermalGenerator.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(var5 + 83, var6 + 24, 176, 0, 11, 10);
        }
        if (this.geothermalGenerator.hasValidSpout()) {
            int ySize = 16 * this.geothermalGenerator.generateWatts / 199;
            this.func_73729_b(var5 + 33, var6 + 21 + (16 - ySize), 176, 10 + this.geothermalGenerator.ticks / 3 % 7 * 16 + (16 - ySize), 46, ySize);
        }
        this.func_73729_b(var5 + 97, var6 + 25, 187, 0, Math.min(this.geothermalGenerator.getScaledElecticalLevel(54), 54), 7);
    }
}

