/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.io;

import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import openmods.utils.io.IStreamSerializer;

public class GameProfileSerializer
implements IStreamSerializer<GameProfile> {
    public static final IStreamSerializer<GameProfile> INSTANCE = new GameProfileSerializer();

    @Override
    public void writeToStream(GameProfile o, PacketBuffer output) {
        GameProfileSerializer.write(o, output);
    }

    @Override
    public GameProfile readFromStream(PacketBuffer input) {
        return GameProfileSerializer.read(input);
    }

    public static void write(GameProfile o, PacketBuffer output) {
        UUID uuid = o.getId();
        output.func_180714_a(uuid == null ? "" : uuid.toString());
        output.func_180714_a(Strings.nullToEmpty((String)o.getName()));
        PropertyMap properties = o.getProperties();
        output.func_150787_b(properties.size());
        for (Property p : properties.values()) {
            output.func_180714_a(p.getName());
            output.func_180714_a(p.getValue());
            String signature = p.getSignature();
            if (signature != null) {
                output.writeBoolean(true);
                output.func_180714_a(signature);
                continue;
            }
            output.writeBoolean(false);
        }
    }

    public static GameProfile read(PacketBuffer input) {
        String uuidStr = input.func_150789_c(Short.MAX_VALUE);
        UUID uuid = Strings.isNullOrEmpty((String)uuidStr) ? null : UUID.fromString(uuidStr);
        String name = input.func_150789_c(Short.MAX_VALUE);
        GameProfile result = new GameProfile(uuid, name);
        int propertyCount = input.func_150792_a();
        PropertyMap properties = result.getProperties();
        for (int i = 0; i < propertyCount; ++i) {
            String key = input.func_150789_c(Short.MAX_VALUE);
            String value = input.func_150789_c(Short.MAX_VALUE);
            if (input.readBoolean()) {
                String signature = input.func_150789_c(Short.MAX_VALUE);
                properties.put((Object)key, (Object)new Property(key, value, signature));
                continue;
            }
            properties.put((Object)key, (Object)new Property(key, value));
        }
        return result;
    }
}

