/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import openmods.utils.bitmap.IReadableBitMap;

public class SidedInventoryAdapter
implements ISidedInventory {
    private final IInventory inventory;
    private final Map<Integer, SlotInfo> slots = Maps.newHashMap();

    public SidedInventoryAdapter(IInventory inventory) {
        this.inventory = inventory;
    }

    public void registerSlot(Enum<?> slot, IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
        this.registerSlot(slot.ordinal(), sideFlags, canInsert, canExtract);
    }

    public void registerSlot(int slot, IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
        int sizeInventory = this.inventory.func_70302_i_();
        Preconditions.checkArgument((slot >= 0 && slot < sizeInventory ? 1 : 0) != 0, (String)"Tried to register invalid slot: %s (inventory size: %s)", (int)slot, (int)sizeInventory);
        this.slots.put(slot, new SlotInfo(sideFlags, canInsert, canExtract));
    }

    public void registerSlots(int start, int count, IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
        for (int i = start; i < start + count; ++i) {
            this.registerSlot(i, sideFlags, canInsert, canExtract);
        }
    }

    public void registerAllSlots(IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            this.registerSlot(i, sideFlags, canInsert, canExtract);
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inventory.func_70300_a(entityplayer);
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return this.inventory.func_94041_b(i, itemstack);
    }

    public int[] func_180463_a(EnumFacing dir) {
        HashSet result = Sets.newHashSet();
        for (Map.Entry<Integer, SlotInfo> entry : this.slots.entrySet()) {
            if (!entry.getValue().canAccessFromSide(dir)) continue;
            result.add(entry.getKey());
        }
        return Ints.toArray((Collection)result);
    }

    public boolean func_180462_a(int slotIndex, @Nonnull ItemStack itemstack, EnumFacing dir) {
        SlotInfo slot = this.slots.get(slotIndex);
        if (slot == null) {
            return false;
        }
        return slot.canInsert && slot.canAccessFromSide(dir) && this.inventory.func_94041_b(slotIndex, itemstack);
    }

    public boolean func_180461_b(int slotIndex, @Nonnull ItemStack itemstack, EnumFacing dir) {
        SlotInfo slot = this.slots.get(slotIndex);
        if (slot == null) {
            return false;
        }
        return slot.canExtract && slot.canAccessFromSide(dir);
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public void func_70296_d() {
        this.inventory.func_70296_d();
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174890_g();
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    private class SlotInfo {
        private final IReadableBitMap<EnumFacing> sideFlags;
        private final boolean canInsert;
        private final boolean canExtract;

        private SlotInfo(IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
            this.sideFlags = sideFlags;
            this.canInsert = canInsert;
            this.canExtract = canExtract;
        }

        private boolean canAccessFromSide(EnumFacing side) {
            return this.sideFlags.get(side);
        }
    }
}

