/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexFormat;
import openmods.LibConfig;
import openmods.Log;

public class TessellatorPool {
    private final Queue<Tessellator> pool = new ConcurrentLinkedQueue<Tessellator>();
    private final AtomicInteger count = new AtomicInteger();
    public static final TessellatorPool instance = new TessellatorPool();

    private TessellatorPool() {
    }

    private Tessellator reserveTessellator() {
        Tessellator tes = this.pool.poll();
        if (tes == null) {
            int id = this.count.incrementAndGet();
            if (id > LibConfig.tessellatorPoolLimit) {
                Log.warn("Maximum number of tessellators in use reached. Something may leak them!", new Object[0]);
            }
            tes = new Tessellator(32768);
        }
        return tes;
    }

    public void startDrawing(int primitive, VertexFormat vertexFormat, WorldRendererUser user) {
        Tessellator tes = this.reserveTessellator();
        BufferBuilder wr = tes.func_178180_c();
        wr.func_181668_a(primitive, vertexFormat);
        user.execute(wr);
        tes.func_78381_a();
        this.pool.add(tes);
    }

    public static interface WorldRendererUser {
        public void execute(BufferBuilder var1);
    }
}

